%------------------------------------------------------------------------------
% File     : ITP141^2 : TPTP v9.2.0. Released v7.5.0.
% Domain   : Interactive Theorem Proving
% Problem  : Sledgehammer PHoareTotal problem prob_135__3259094_1
% Version  : Especial.
% English  :

% Refs     : [BH+15] Blanchette et al. (2015), Mining the Archive of Formal
%          : [Des21] Desharnais (2021), Email to Geoff Sutcliffe
% Source   : [Des21]
% Names    : PHoareTotal/prob_135__3259094_1 [Des21]

% Status   : Theorem
% Rating   : 0.67 v9.1.0, 0.33 v9.0.0, 0.67 v8.2.0, 0.33 v8.1.0, 0.50 v7.5.0
% Syntax   : Number of formulae    :  343 ( 160 unt;  76 typ;   0 def)
%            Number of atoms       :  633 ( 253 equ;   0 cnn)
%            Maximal formula atoms :   21 (   2 avg)
%            Number of connectives : 4580 ( 104   ~;  14   |;  72   &;4109   @)
%                                         (   0 <=>; 281  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   28 (   8 avg)
%            Number of types       :    6 (   5 usr)
%            Number of type conns  :  655 ( 655   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :   74 (  71 usr;   8 con; 0-6 aty)
%            Number of variables   : 1348 ( 173   ^;1074   !;  28   ?;1348   :)
%                                         (  73  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TH1_THM_EQU_NAR

% Comments : This file was generated by Sledgehammer 2021-02-23 16:17:57.953
%------------------------------------------------------------------------------
% Could-be-implicit typings (7)
thf(ty_t_Product__Type_Ounit,type,
    product_unit: $tType ).

thf(ty_t_Product__Type_Oprod,type,
    product_prod: $tType > $tType > $tType ).

thf(ty_t_PLang_Ostate,type,
    state: $tType ).

thf(ty_t_PLang_Ocom,type,
    com: $tType ).

thf(ty_t_Set_Oset,type,
    set: $tType > $tType ).

thf(ty_t_Nat_Onat,type,
    nat: $tType ).

thf(ty_tf_a,type,
    a: $tType ).

% Explicit typings (69)
thf(sy_cl_HOL_Otype,type,
    type: 
      !>[A: $tType] : $o ).

thf(sy_cl_Orderings_Obot,type,
    bot: 
      !>[A: $tType] : $o ).

thf(sy_c_Basic__BNFs_Ofsts,type,
    basic_fsts: 
      !>[A: $tType,B: $tType] : ( ( product_prod @ A @ B ) > ( set @ A ) ) ).

thf(sy_c_Basic__BNFs_Osnds,type,
    basic_snds: 
      !>[A: $tType,B: $tType] : ( ( product_prod @ A @ B ) > ( set @ B ) ) ).

thf(sy_c_Fun__Def_Oreduction__pair,type,
    fun_reduction_pair: 
      !>[A: $tType] : ( ( product_prod @ ( set @ ( product_prod @ A @ A ) ) @ ( set @ ( product_prod @ A @ A ) ) ) > $o ) ).

thf(sy_c_Fun__Def_Orp__inv__image,type,
    fun_rp_inv_image: 
      !>[A: $tType,B: $tType] : ( ( product_prod @ ( set @ ( product_prod @ A @ A ) ) @ ( set @ ( product_prod @ A @ A ) ) ) > ( B > A ) > ( product_prod @ ( set @ ( product_prod @ B @ B ) ) @ ( set @ ( product_prod @ B @ B ) ) ) ) ).

thf(sy_c_HOL_OThe,type,
    the: 
      !>[A: $tType] : ( ( A > $o ) > A ) ).

thf(sy_c_If,type,
    if: 
      !>[A: $tType] : ( $o > A > A > A ) ).

thf(sy_c_Nat_OSuc,type,
    suc: nat > nat ).

thf(sy_c_Order__Relation_Oabove,type,
    order_above: 
      !>[A: $tType] : ( ( set @ ( product_prod @ A @ A ) ) > A > ( set @ A ) ) ).

thf(sy_c_Order__Relation_OaboveS,type,
    order_aboveS: 
      !>[A: $tType] : ( ( set @ ( product_prod @ A @ A ) ) > A > ( set @ A ) ) ).

thf(sy_c_Order__Relation_Olinear__order__on,type,
    order_1409979114der_on: 
      !>[A: $tType] : ( ( set @ A ) > ( set @ ( product_prod @ A @ A ) ) > $o ) ).

thf(sy_c_Order__Relation_Opreorder__on,type,
    order_preorder_on: 
      !>[A: $tType] : ( ( set @ A ) > ( set @ ( product_prod @ A @ A ) ) > $o ) ).

thf(sy_c_Orderings_Obot__class_Obot,type,
    bot_bot: 
      !>[A: $tType] : A ).

thf(sy_c_Orderings_Oord__class_Oless,type,
    ord_less: 
      !>[A: $tType] : ( A > A > $o ) ).

thf(sy_c_PHoareTotal__Mirabelle__nfzgdgthbw_Octvalid,type,
    pHoare304044376tvalid: 
      !>[A: $tType] : ( ( set @ ( product_prod @ ( A > state > $o ) @ ( product_prod @ com @ ( A > state > $o ) ) ) ) > ( A > state > $o ) > com > ( A > state > $o ) > $o ) ).

thf(sy_c_PHoareTotal__Mirabelle__nfzgdgthbw_Othoare,type,
    pHoare166426476thoare: 
      !>[A: $tType] : ( ( set @ ( product_prod @ ( A > state > $o ) @ ( product_prod @ com @ ( A > state > $o ) ) ) ) > ( A > state > $o ) > com > ( A > state > $o ) > $o ) ).

thf(sy_c_PHoareTotal__Mirabelle__nfzgdgthbw_Otvalid,type,
    pHoare987424603tvalid: 
      !>[A: $tType] : ( ( A > state > $o ) > com > ( A > state > $o ) > $o ) ).

thf(sy_c_PHoare_Ocnvalid,type,
    cnvalid: 
      !>[A: $tType] : ( ( set @ ( product_prod @ ( A > state > $o ) @ ( product_prod @ com @ ( A > state > $o ) ) ) ) > nat > ( A > state > $o ) > com > ( A > state > $o ) > $o ) ).

thf(sy_c_PHoare_Ocvalid,type,
    cvalid: 
      !>[A: $tType] : ( ( set @ ( product_prod @ ( A > state > $o ) @ ( product_prod @ com @ ( A > state > $o ) ) ) ) > ( A > state > $o ) > com > ( A > state > $o ) > $o ) ).

thf(sy_c_PHoare_Ohoare,type,
    hoare: 
      !>[A: $tType] : ( ( set @ ( product_prod @ ( A > state > $o ) @ ( product_prod @ com @ ( A > state > $o ) ) ) ) > ( A > state > $o ) > com > ( A > state > $o ) > $o ) ).

thf(sy_c_PHoare_Onvalid,type,
    nvalid: 
      !>[A: $tType] : ( nat > ( A > state > $o ) > com > ( A > state > $o ) > $o ) ).

thf(sy_c_PHoare_Onvalids,type,
    nvalids: 
      !>[A: $tType] : ( nat > ( set @ ( product_prod @ ( A > state > $o ) @ ( product_prod @ com @ ( A > state > $o ) ) ) ) > $o ) ).

thf(sy_c_PHoare_Ovalid,type,
    valid: 
      !>[A: $tType] : ( ( A > state > $o ) > com > ( A > state > $o ) > $o ) ).

thf(sy_c_PHoare_Ovalids,type,
    valids: 
      !>[A: $tType] : ( ( set @ ( product_prod @ ( A > state > $o ) @ ( product_prod @ com @ ( A > state > $o ) ) ) ) > $o ) ).

thf(sy_c_PLang_Obody,type,
    body: com ).

thf(sy_c_PLang_Ocom_OCALL,type,
    call: com ).

thf(sy_c_PLang_Ocom_OSemi,type,
    semi: com > com > com ).

thf(sy_c_PLang_Ocom_OWhile,type,
    while: ( state > $o ) > com > com ).

thf(sy_c_PLang_Oexec,type,
    exec: state > com > state > $o ).

thf(sy_c_PLang_Oexecn,type,
    execn: state > com > nat > state > $o ).

thf(sy_c_PTermi_Otermi,type,
    termi: com > state > $o ).

thf(sy_c_Product__Type_OPair,type,
    product_Pair: 
      !>[A: $tType,B: $tType] : ( A > B > ( product_prod @ A @ B ) ) ).

thf(sy_c_Product__Type_Ointernal__case__prod,type,
    produc2004651681e_prod: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( A > B > C ) > ( product_prod @ A @ B ) > C ) ).

thf(sy_c_Product__Type_Oold_Oprod_Orec__prod,type,
    product_rec_prod: 
      !>[A: $tType,B: $tType,T: $tType] : ( ( A > B > T ) > ( product_prod @ A @ B ) > T ) ).

thf(sy_c_Product__Type_Oold_Oprod_Orec__set__prod,type,
    product_rec_set_prod: 
      !>[A: $tType,B: $tType,T: $tType] : ( ( A > B > T ) > ( product_prod @ A @ B ) > T > $o ) ).

thf(sy_c_Product__Type_Oold_Ounit_Orec__set__unit,type,
    product_rec_set_unit: 
      !>[T: $tType] : ( T > product_unit > T > $o ) ).

thf(sy_c_Product__Type_Oold_Ounit_Orec__unit,type,
    product_rec_unit: 
      !>[T: $tType] : ( T > product_unit > T ) ).

thf(sy_c_Product__Type_Oprod_Ocase__prod,type,
    product_case_prod: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( A > B > C ) > ( product_prod @ A @ B ) > C ) ).

thf(sy_c_Relation_ODomain,type,
    domain: 
      !>[A: $tType,B: $tType] : ( ( set @ ( product_prod @ A @ B ) ) > ( set @ A ) ) ).

thf(sy_c_Relation_OId__on,type,
    id_on: 
      !>[A: $tType] : ( ( set @ A ) > ( set @ ( product_prod @ A @ A ) ) ) ).

thf(sy_c_Relation_OPowp,type,
    powp: 
      !>[A: $tType] : ( ( A > $o ) > ( set @ A ) > $o ) ).

thf(sy_c_Relation_ORange,type,
    range: 
      !>[A: $tType,B: $tType] : ( ( set @ ( product_prod @ A @ B ) ) > ( set @ B ) ) ).

thf(sy_c_Relation_ORangep,type,
    rangep: 
      !>[A: $tType,B: $tType] : ( ( A > B > $o ) > B > $o ) ).

thf(sy_c_Relation_Oinv__image,type,
    inv_image: 
      !>[B: $tType,A: $tType] : ( ( set @ ( product_prod @ B @ B ) ) > ( A > B ) > ( set @ ( product_prod @ A @ A ) ) ) ).

thf(sy_c_Relation_Oirrefl,type,
    irrefl: 
      !>[A: $tType] : ( ( set @ ( product_prod @ A @ A ) ) > $o ) ).

thf(sy_c_Relation_Oirreflp,type,
    irreflp: 
      !>[A: $tType] : ( ( A > A > $o ) > $o ) ).

thf(sy_c_Relation_Orefl__on,type,
    refl_on: 
      !>[A: $tType] : ( ( set @ A ) > ( set @ ( product_prod @ A @ A ) ) > $o ) ).

thf(sy_c_Relation_Ototal__on,type,
    total_on: 
      !>[A: $tType] : ( ( set @ A ) > ( set @ ( product_prod @ A @ A ) ) > $o ) ).

thf(sy_c_Relation_Otrans,type,
    trans: 
      !>[A: $tType] : ( ( set @ ( product_prod @ A @ A ) ) > $o ) ).

thf(sy_c_Set_OBall,type,
    ball: 
      !>[A: $tType] : ( ( set @ A ) > ( A > $o ) > $o ) ).

thf(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( ( A > $o ) > ( set @ A ) ) ).

thf(sy_c_Set_Oinsert,type,
    insert: 
      !>[A: $tType] : ( A > ( set @ A ) > ( set @ A ) ) ).

thf(sy_c_Set_Ois__empty,type,
    is_empty: 
      !>[A: $tType] : ( ( set @ A ) > $o ) ).

thf(sy_c_Set_Ois__singleton,type,
    is_singleton: 
      !>[A: $tType] : ( ( set @ A ) > $o ) ).

thf(sy_c_Set_Othe__elem,type,
    the_elem: 
      !>[A: $tType] : ( ( set @ A ) > A ) ).

thf(sy_c_Wellfounded_Oless__than,type,
    less_than: set @ ( product_prod @ nat @ nat ) ).

thf(sy_c_Wellfounded_Olex__prod,type,
    lex_prod: 
      !>[A: $tType,B: $tType] : ( ( set @ ( product_prod @ A @ A ) ) > ( set @ ( product_prod @ B @ B ) ) > ( set @ ( product_prod @ ( product_prod @ A @ B ) @ ( product_prod @ A @ B ) ) ) ) ).

thf(sy_c_Wellfounded_Omeasure,type,
    measure: 
      !>[A: $tType] : ( ( A > nat ) > ( set @ ( product_prod @ A @ A ) ) ) ).

thf(sy_c_Wellfounded_Omlex__prod,type,
    mlex_prod: 
      !>[A: $tType] : ( ( A > nat ) > ( set @ ( product_prod @ A @ A ) ) > ( set @ ( product_prod @ A @ A ) ) ) ).

thf(sy_c_Wellfounded_Opred__nat,type,
    pred_nat: set @ ( product_prod @ nat @ nat ) ).

thf(sy_c_Wellfounded_Owf,type,
    wf: 
      !>[A: $tType] : ( ( set @ ( product_prod @ A @ A ) ) > $o ) ).

thf(sy_c_Wfrec_Osame__fst,type,
    same_fst: 
      !>[A: $tType,B: $tType] : ( ( A > $o ) > ( A > ( set @ ( product_prod @ B @ B ) ) ) > ( set @ ( product_prod @ ( product_prod @ A @ B ) @ ( product_prod @ A @ B ) ) ) ) ).

thf(sy_c_Zorn_OChains,type,
    chains: 
      !>[A: $tType] : ( ( set @ ( product_prod @ A @ A ) ) > ( set @ ( set @ A ) ) ) ).

thf(sy_c_member,type,
    member: 
      !>[A: $tType] : ( A > ( set @ A ) > $o ) ).

thf(sy_v_Pa,type,
    pa: a > state > $o ).

thf(sy_v_Qa,type,
    qa: a > state > $o ).

thf(sy_v_r,type,
    r: set @ ( product_prod @ state @ state ) ).

thf(sy_v_x,type,
    x: state ).

% Relevant facts (256)
thf(fact_0_thoare_OAsm,axiom,
    ! [A: $tType,P: A > state > $o,Q: A > state > $o] : ( pHoare166426476thoare @ A @ ( insert @ ( product_prod @ ( A > state > $o ) @ ( product_prod @ com @ ( A > state > $o ) ) ) @ ( product_Pair @ ( A > state > $o ) @ ( product_prod @ com @ ( A > state > $o ) ) @ P @ ( product_Pair @ com @ ( A > state > $o ) @ call @ Q ) ) @ ( bot_bot @ ( set @ ( product_prod @ ( A > state > $o ) @ ( product_prod @ com @ ( A > state > $o ) ) ) ) ) ) @ P @ call @ Q ) ).

% thoare.Asm
thf(fact_1_weaken__post,axiom,
    ! [A: $tType,C2: set @ ( product_prod @ ( A > state > $o ) @ ( product_prod @ com @ ( A > state > $o ) ) ),P: A > state > $o,C3: com,Q: A > state > $o,Q2: A > state > $o] :
      ( ( pHoare166426476thoare @ A @ C2 @ P @ C3 @ Q )
     => ( ! [Z: A,S: state] :
            ( ( Q @ Z @ S )
           => ( Q2 @ Z @ S ) )
       => ( pHoare166426476thoare @ A @ C2 @ P @ C3 @ Q2 ) ) ) ).

% weaken_post
thf(fact_2_thoare_OConseq,axiom,
    ! [A: $tType,C2: set @ ( product_prod @ ( A > state > $o ) @ ( product_prod @ com @ ( A > state > $o ) ) ),P2: A > state > $o,C3: com,Q2: A > state > $o,P: A > state > $o,Q: A > state > $o] :
      ( ( pHoare166426476thoare @ A @ C2 @ P2 @ C3 @ Q2 )
     => ( ( ! [S: state,T2: state] :
              ( ! [Z2: A] :
                  ( ( P2 @ Z2 @ S )
                 => ( Q2 @ Z2 @ T2 ) )
             => ! [Z: A] :
                  ( ( P @ Z @ S )
                 => ( Q @ Z @ T2 ) ) )
          & ! [S: state] :
              ( ? [Z: A] : ( P @ Z @ S )
             => ? [Z2: A] : ( P2 @ Z2 @ S ) ) )
       => ( pHoare166426476thoare @ A @ C2 @ P @ C3 @ Q ) ) ) ).

% thoare.Conseq
thf(fact_3_PHoareTotal__Mirabelle__nfzgdgthbw_Ostrengthen__pre,axiom,
    ! [A: $tType,P2: A > state > $o,P: A > state > $o,C2: set @ ( product_prod @ ( A > state > $o ) @ ( product_prod @ com @ ( A > state > $o ) ) ),C3: com,Q: A > state > $o] :
      ( ! [Z: A,S: state] :
          ( ( P2 @ Z @ S )
         => ( P @ Z @ S ) )
     => ( ( pHoare166426476thoare @ A @ C2 @ P @ C3 @ Q )
       => ( pHoare166426476thoare @ A @ C2 @ P2 @ C3 @ Q ) ) ) ).

% PHoareTotal_Mirabelle_nfzgdgthbw.strengthen_pre
thf(fact_4_singleton__conv,axiom,
    ! [A: $tType,A2: A] :
      ( ( collect @ A
        @ ^ [X: A] : ( X = A2 ) )
      = ( insert @ A @ A2 @ ( bot_bot @ ( set @ A ) ) ) ) ).

% singleton_conv
thf(fact_5_singleton__conv2,axiom,
    ! [A: $tType,A2: A] :
      ( ( collect @ A
        @ ( ^ [Y: A,Z3: A] : ( Y = Z3 )
          @ A2 ) )
      = ( insert @ A @ A2 @ ( bot_bot @ ( set @ A ) ) ) ) ).

% singleton_conv2
thf(fact_6_singletonI,axiom,
    ! [A: $tType,A2: A] : ( member @ A @ A2 @ ( insert @ A @ A2 @ ( bot_bot @ ( set @ A ) ) ) ) ).

% singletonI
thf(fact_7_termi_Ointros_I7_J,axiom,
    ! [S2: state] :
      ( ( termi @ body @ S2 )
     => ( termi @ call @ S2 ) ) ).

% termi.intros(7)
thf(fact_8_exec_Ointros_I7_J,axiom,
    ! [S2: state,T3: state] :
      ( ( exec @ S2 @ body @ T3 )
     => ( exec @ S2 @ call @ T3 ) ) ).

% exec.intros(7)
thf(fact_9_thoare_OCall,axiom,
    ! [A: $tType,R: set @ ( product_prod @ state @ state ),P: A > state > $o,Q: A > state > $o] :
      ( ( wf @ state @ R )
     => ( ! [S3: state] :
            ( pHoare166426476thoare @ A
            @ ( insert @ ( product_prod @ ( A > state > $o ) @ ( product_prod @ com @ ( A > state > $o ) ) )
              @ ( product_Pair @ ( A > state > $o ) @ ( product_prod @ com @ ( A > state > $o ) )
                @ ^ [Z4: A,S4: state] :
                    ( ( P @ Z4 @ S4 )
                    & ( member @ ( product_prod @ state @ state ) @ ( product_Pair @ state @ state @ S4 @ S3 ) @ R ) )
                @ ( product_Pair @ com @ ( A > state > $o ) @ call @ Q ) )
              @ ( bot_bot @ ( set @ ( product_prod @ ( A > state > $o ) @ ( product_prod @ com @ ( A > state > $o ) ) ) ) ) )
            @ ^ [Z4: A,S4: state] :
                ( ( P @ Z4 @ S4 )
                & ( S4 = S3 ) )
            @ body
            @ Q )
       => ( pHoare166426476thoare @ A @ ( bot_bot @ ( set @ ( product_prod @ ( A > state > $o ) @ ( product_prod @ com @ ( A > state > $o ) ) ) ) ) @ P @ call @ Q ) ) ) ).

% thoare.Call
thf(fact_10_insertCI,axiom,
    ! [A: $tType,A2: A,B2: set @ A,B3: A] :
      ( ( ~ ( member @ A @ A2 @ B2 )
       => ( A2 = B3 ) )
     => ( member @ A @ A2 @ ( insert @ A @ B3 @ B2 ) ) ) ).

% insertCI
thf(fact_11_insert__iff,axiom,
    ! [A: $tType,A2: A,B3: A,A3: set @ A] :
      ( ( member @ A @ A2 @ ( insert @ A @ B3 @ A3 ) )
      = ( ( A2 = B3 )
        | ( member @ A @ A2 @ A3 ) ) ) ).

% insert_iff
thf(fact_12_insert__absorb2,axiom,
    ! [A: $tType,X2: A,A3: set @ A] :
      ( ( insert @ A @ X2 @ ( insert @ A @ X2 @ A3 ) )
      = ( insert @ A @ X2 @ A3 ) ) ).

% insert_absorb2
thf(fact_13_hoare_OCall,axiom,
    ! [A: $tType,P: A > state > $o,Q: A > state > $o] :
      ( ( hoare @ A @ ( insert @ ( product_prod @ ( A > state > $o ) @ ( product_prod @ com @ ( A > state > $o ) ) ) @ ( product_Pair @ ( A > state > $o ) @ ( product_prod @ com @ ( A > state > $o ) ) @ P @ ( product_Pair @ com @ ( A > state > $o ) @ call @ Q ) ) @ ( bot_bot @ ( set @ ( product_prod @ ( A > state > $o ) @ ( product_prod @ com @ ( A > state > $o ) ) ) ) ) ) @ P @ body @ Q )
     => ( hoare @ A @ ( bot_bot @ ( set @ ( product_prod @ ( A > state > $o ) @ ( product_prod @ com @ ( A > state > $o ) ) ) ) ) @ P @ call @ Q ) ) ).

% hoare.Call
thf(fact_14_empty__iff,axiom,
    ! [A: $tType,C3: A] :
      ~ ( member @ A @ C3 @ ( bot_bot @ ( set @ A ) ) ) ).

% empty_iff
thf(fact_15_all__not__in__conv,axiom,
    ! [A: $tType,A3: set @ A] :
      ( ( ! [X: A] :
            ~ ( member @ A @ X @ A3 ) )
      = ( A3
        = ( bot_bot @ ( set @ A ) ) ) ) ).

% all_not_in_conv
thf(fact_16_empty__Collect__eq,axiom,
    ! [A: $tType,P: A > $o] :
      ( ( ( bot_bot @ ( set @ A ) )
        = ( collect @ A @ P ) )
      = ( ! [X: A] :
            ~ ( P @ X ) ) ) ).

% empty_Collect_eq
thf(fact_17_Collect__empty__eq,axiom,
    ! [A: $tType,P: A > $o] :
      ( ( ( collect @ A @ P )
        = ( bot_bot @ ( set @ A ) ) )
      = ( ! [X: A] :
            ~ ( P @ X ) ) ) ).

% Collect_empty_eq
thf(fact_18_hoare_OConseq,axiom,
    ! [A: $tType,C2: set @ ( product_prod @ ( A > state > $o ) @ ( product_prod @ com @ ( A > state > $o ) ) ),P2: A > state > $o,C3: com,Q2: A > state > $o,P: A > state > $o,Q: A > state > $o] :
      ( ( hoare @ A @ C2 @ P2 @ C3 @ Q2 )
     => ( ! [S: state,T2: state] :
            ( ! [Z2: A] :
                ( ( P2 @ Z2 @ S )
               => ( Q2 @ Z2 @ T2 ) )
           => ! [Z: A] :
                ( ( P @ Z @ S )
               => ( Q @ Z @ T2 ) ) )
       => ( hoare @ A @ C2 @ P @ C3 @ Q ) ) ) ).

% hoare.Conseq
thf(fact_19_PHoare_Ostrengthen__pre,axiom,
    ! [A: $tType,P2: A > state > $o,P: A > state > $o,C2: set @ ( product_prod @ ( A > state > $o ) @ ( product_prod @ com @ ( A > state > $o ) ) ),C3: com,Q: A > state > $o] :
      ( ! [Z: A,S: state] :
          ( ( P2 @ Z @ S )
         => ( P @ Z @ S ) )
     => ( ( hoare @ A @ C2 @ P @ C3 @ Q )
       => ( hoare @ A @ C2 @ P2 @ C3 @ Q ) ) ) ).

% PHoare.strengthen_pre
thf(fact_20_ex__in__conv,axiom,
    ! [A: $tType,A3: set @ A] :
      ( ( ? [X: A] : ( member @ A @ X @ A3 ) )
      = ( A3
       != ( bot_bot @ ( set @ A ) ) ) ) ).

% ex_in_conv
thf(fact_21_equals0I,axiom,
    ! [A: $tType,A3: set @ A] :
      ( ! [Y2: A] :
          ~ ( member @ A @ Y2 @ A3 )
     => ( A3
        = ( bot_bot @ ( set @ A ) ) ) ) ).

% equals0I
thf(fact_22_equals0D,axiom,
    ! [A: $tType,A3: set @ A,A2: A] :
      ( ( A3
        = ( bot_bot @ ( set @ A ) ) )
     => ~ ( member @ A @ A2 @ A3 ) ) ).

% equals0D
thf(fact_23_emptyE,axiom,
    ! [A: $tType,A2: A] :
      ~ ( member @ A @ A2 @ ( bot_bot @ ( set @ A ) ) ) ).

% emptyE
thf(fact_24_mk__disjoint__insert,axiom,
    ! [A: $tType,A2: A,A3: set @ A] :
      ( ( member @ A @ A2 @ A3 )
     => ? [B4: set @ A] :
          ( ( A3
            = ( insert @ A @ A2 @ B4 ) )
          & ~ ( member @ A @ A2 @ B4 ) ) ) ).

% mk_disjoint_insert
thf(fact_25_insert__commute,axiom,
    ! [A: $tType,X2: A,Y3: A,A3: set @ A] :
      ( ( insert @ A @ X2 @ ( insert @ A @ Y3 @ A3 ) )
      = ( insert @ A @ Y3 @ ( insert @ A @ X2 @ A3 ) ) ) ).

% insert_commute
thf(fact_26_insert__eq__iff,axiom,
    ! [A: $tType,A2: A,A3: set @ A,B3: A,B2: set @ A] :
      ( ~ ( member @ A @ A2 @ A3 )
     => ( ~ ( member @ A @ B3 @ B2 )
       => ( ( ( insert @ A @ A2 @ A3 )
            = ( insert @ A @ B3 @ B2 ) )
          = ( ( ( A2 = B3 )
             => ( A3 = B2 ) )
            & ( ( A2 != B3 )
             => ? [C4: set @ A] :
                  ( ( A3
                    = ( insert @ A @ B3 @ C4 ) )
                  & ~ ( member @ A @ B3 @ C4 )
                  & ( B2
                    = ( insert @ A @ A2 @ C4 ) )
                  & ~ ( member @ A @ A2 @ C4 ) ) ) ) ) ) ) ).

% insert_eq_iff
thf(fact_27_insert__absorb,axiom,
    ! [A: $tType,A2: A,A3: set @ A] :
      ( ( member @ A @ A2 @ A3 )
     => ( ( insert @ A @ A2 @ A3 )
        = A3 ) ) ).

% insert_absorb
thf(fact_28_insert__ident,axiom,
    ! [A: $tType,X2: A,A3: set @ A,B2: set @ A] :
      ( ~ ( member @ A @ X2 @ A3 )
     => ( ~ ( member @ A @ X2 @ B2 )
       => ( ( ( insert @ A @ X2 @ A3 )
            = ( insert @ A @ X2 @ B2 ) )
          = ( A3 = B2 ) ) ) ) ).

% insert_ident
thf(fact_29_Set_Oset__insert,axiom,
    ! [A: $tType,X2: A,A3: set @ A] :
      ( ( member @ A @ X2 @ A3 )
     => ~ ! [B4: set @ A] :
            ( ( A3
              = ( insert @ A @ X2 @ B4 ) )
           => ( member @ A @ X2 @ B4 ) ) ) ).

% Set.set_insert
thf(fact_30_insertI2,axiom,
    ! [A: $tType,A2: A,B2: set @ A,B3: A] :
      ( ( member @ A @ A2 @ B2 )
     => ( member @ A @ A2 @ ( insert @ A @ B3 @ B2 ) ) ) ).

% insertI2
thf(fact_31_insertI1,axiom,
    ! [A: $tType,A2: A,B2: set @ A] : ( member @ A @ A2 @ ( insert @ A @ A2 @ B2 ) ) ).

% insertI1
thf(fact_32_insertE,axiom,
    ! [A: $tType,A2: A,B3: A,A3: set @ A] :
      ( ( member @ A @ A2 @ ( insert @ A @ B3 @ A3 ) )
     => ( ( A2 != B3 )
       => ( member @ A @ A2 @ A3 ) ) ) ).

% insertE
thf(fact_33_empty__def,axiom,
    ! [A: $tType] :
      ( ( bot_bot @ ( set @ A ) )
      = ( collect @ A
        @ ^ [X: A] : $false ) ) ).

% empty_def
thf(fact_34_insert__Collect,axiom,
    ! [A: $tType,A2: A,P: A > $o] :
      ( ( insert @ A @ A2 @ ( collect @ A @ P ) )
      = ( collect @ A
        @ ^ [U: A] :
            ( ( U != A2 )
           => ( P @ U ) ) ) ) ).

% insert_Collect
thf(fact_35_insert__compr,axiom,
    ! [A: $tType] :
      ( ( insert @ A )
      = ( ^ [A4: A,B5: set @ A] :
            ( collect @ A
            @ ^ [X: A] :
                ( ( X = A4 )
                | ( member @ A @ X @ B5 ) ) ) ) ) ).

% insert_compr
thf(fact_36_singleton__inject,axiom,
    ! [A: $tType,A2: A,B3: A] :
      ( ( ( insert @ A @ A2 @ ( bot_bot @ ( set @ A ) ) )
        = ( insert @ A @ B3 @ ( bot_bot @ ( set @ A ) ) ) )
     => ( A2 = B3 ) ) ).

% singleton_inject
thf(fact_37_insert__not__empty,axiom,
    ! [A: $tType,A2: A,A3: set @ A] :
      ( ( insert @ A @ A2 @ A3 )
     != ( bot_bot @ ( set @ A ) ) ) ).

% insert_not_empty
thf(fact_38_doubleton__eq__iff,axiom,
    ! [A: $tType,A2: A,B3: A,C3: A,D: A] :
      ( ( ( insert @ A @ A2 @ ( insert @ A @ B3 @ ( bot_bot @ ( set @ A ) ) ) )
        = ( insert @ A @ C3 @ ( insert @ A @ D @ ( bot_bot @ ( set @ A ) ) ) ) )
      = ( ( ( A2 = C3 )
          & ( B3 = D ) )
        | ( ( A2 = D )
          & ( B3 = C3 ) ) ) ) ).

% doubleton_eq_iff
thf(fact_39_singleton__iff,axiom,
    ! [A: $tType,B3: A,A2: A] :
      ( ( member @ A @ B3 @ ( insert @ A @ A2 @ ( bot_bot @ ( set @ A ) ) ) )
      = ( B3 = A2 ) ) ).

% singleton_iff
thf(fact_40_singletonD,axiom,
    ! [A: $tType,B3: A,A2: A] :
      ( ( member @ A @ B3 @ ( insert @ A @ A2 @ ( bot_bot @ ( set @ A ) ) ) )
     => ( B3 = A2 ) ) ).

% singletonD
thf(fact_41_hoare_OAsm,axiom,
    ! [A: $tType,P: A > state > $o,Q: A > state > $o] : ( hoare @ A @ ( insert @ ( product_prod @ ( A > state > $o ) @ ( product_prod @ com @ ( A > state > $o ) ) ) @ ( product_Pair @ ( A > state > $o ) @ ( product_prod @ com @ ( A > state > $o ) ) @ P @ ( product_Pair @ com @ ( A > state > $o ) @ call @ Q ) ) @ ( bot_bot @ ( set @ ( product_prod @ ( A > state > $o ) @ ( product_prod @ com @ ( A > state > $o ) ) ) ) ) ) @ P @ call @ Q ) ).

% hoare.Asm
thf(fact_42_Collect__conv__if2,axiom,
    ! [A: $tType,P: A > $o,A2: A] :
      ( ( ( P @ A2 )
       => ( ( collect @ A
            @ ^ [X: A] :
                ( ( A2 = X )
                & ( P @ X ) ) )
          = ( insert @ A @ A2 @ ( bot_bot @ ( set @ A ) ) ) ) )
      & ( ~ ( P @ A2 )
       => ( ( collect @ A
            @ ^ [X: A] :
                ( ( A2 = X )
                & ( P @ X ) ) )
          = ( bot_bot @ ( set @ A ) ) ) ) ) ).

% Collect_conv_if2
thf(fact_43_Collect__conv__if,axiom,
    ! [A: $tType,P: A > $o,A2: A] :
      ( ( ( P @ A2 )
       => ( ( collect @ A
            @ ^ [X: A] :
                ( ( X = A2 )
                & ( P @ X ) ) )
          = ( insert @ A @ A2 @ ( bot_bot @ ( set @ A ) ) ) ) )
      & ( ~ ( P @ A2 )
       => ( ( collect @ A
            @ ^ [X: A] :
                ( ( X = A2 )
                & ( P @ X ) ) )
          = ( bot_bot @ ( set @ A ) ) ) ) ) ).

% Collect_conv_if
thf(fact_44_wf__empty,axiom,
    ! [A: $tType] : ( wf @ A @ ( bot_bot @ ( set @ ( product_prod @ A @ A ) ) ) ) ).

% wf_empty
thf(fact_45_mem__Collect__eq,axiom,
    ! [A: $tType,A2: A,P: A > $o] :
      ( ( member @ A @ A2 @ ( collect @ A @ P ) )
      = ( P @ A2 ) ) ).

% mem_Collect_eq
thf(fact_46_Collect__mem__eq,axiom,
    ! [A: $tType,A3: set @ A] :
      ( ( collect @ A
        @ ^ [X: A] : ( member @ A @ X @ A3 ) )
      = A3 ) ).

% Collect_mem_eq
thf(fact_47_Collect__cong,axiom,
    ! [A: $tType,P: A > $o,Q: A > $o] :
      ( ! [X3: A] :
          ( ( P @ X3 )
          = ( Q @ X3 ) )
     => ( ( collect @ A @ P )
        = ( collect @ A @ Q ) ) ) ).

% Collect_cong
thf(fact_48_ext,axiom,
    ! [B: $tType,A: $tType,F: A > B,G: A > B] :
      ( ! [X3: A] :
          ( ( F @ X3 )
          = ( G @ X3 ) )
     => ( F = G ) ) ).

% ext
thf(fact_49_wfE__min_H,axiom,
    ! [A: $tType,R2: set @ ( product_prod @ A @ A ),Q: set @ A] :
      ( ( wf @ A @ R2 )
     => ( ( Q
         != ( bot_bot @ ( set @ A ) ) )
       => ~ ! [Z: A] :
              ( ( member @ A @ Z @ Q )
             => ~ ! [Y4: A] :
                    ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ Y4 @ Z ) @ R2 )
                   => ~ ( member @ A @ Y4 @ Q ) ) ) ) ) ).

% wfE_min'
thf(fact_50_the__elem__eq,axiom,
    ! [A: $tType,X2: A] :
      ( ( the_elem @ A @ ( insert @ A @ X2 @ ( bot_bot @ ( set @ A ) ) ) )
      = X2 ) ).

% the_elem_eq
thf(fact_51_bot__apply,axiom,
    ! [C: $tType,D2: $tType] :
      ( ( bot @ C )
     => ( ( bot_bot @ ( D2 > C ) )
        = ( ^ [X: D2] : ( bot_bot @ C ) ) ) ) ).

% bot_apply
thf(fact_52_old_Oprod_Oinject,axiom,
    ! [A: $tType,B: $tType,A2: A,B3: B,A5: A,B6: B] :
      ( ( ( product_Pair @ A @ B @ A2 @ B3 )
        = ( product_Pair @ A @ B @ A5 @ B6 ) )
      = ( ( A2 = A5 )
        & ( B3 = B6 ) ) ) ).

% old.prod.inject
thf(fact_53_prod_Oinject,axiom,
    ! [A: $tType,B: $tType,X1: A,X22: B,Y1: A,Y22: B] :
      ( ( ( product_Pair @ A @ B @ X1 @ X22 )
        = ( product_Pair @ A @ B @ Y1 @ Y22 ) )
      = ( ( X1 = Y1 )
        & ( X22 = Y22 ) ) ) ).

% prod.inject
thf(fact_54_is__singletonI,axiom,
    ! [A: $tType,X2: A] : ( is_singleton @ A @ ( insert @ A @ X2 @ ( bot_bot @ ( set @ A ) ) ) ) ).

% is_singletonI
thf(fact_55_prod__induct7,axiom,
    ! [G2: $tType,F2: $tType,E: $tType,D2: $tType,C: $tType,B: $tType,A: $tType,P: ( product_prod @ A @ ( product_prod @ B @ ( product_prod @ C @ ( product_prod @ D2 @ ( product_prod @ E @ ( product_prod @ F2 @ G2 ) ) ) ) ) ) > $o,X2: product_prod @ A @ ( product_prod @ B @ ( product_prod @ C @ ( product_prod @ D2 @ ( product_prod @ E @ ( product_prod @ F2 @ G2 ) ) ) ) )] :
      ( ! [A6: A,B7: B,C5: C,D3: D2,E2: E,F3: F2,G3: G2] : ( P @ ( product_Pair @ A @ ( product_prod @ B @ ( product_prod @ C @ ( product_prod @ D2 @ ( product_prod @ E @ ( product_prod @ F2 @ G2 ) ) ) ) ) @ A6 @ ( product_Pair @ B @ ( product_prod @ C @ ( product_prod @ D2 @ ( product_prod @ E @ ( product_prod @ F2 @ G2 ) ) ) ) @ B7 @ ( product_Pair @ C @ ( product_prod @ D2 @ ( product_prod @ E @ ( product_prod @ F2 @ G2 ) ) ) @ C5 @ ( product_Pair @ D2 @ ( product_prod @ E @ ( product_prod @ F2 @ G2 ) ) @ D3 @ ( product_Pair @ E @ ( product_prod @ F2 @ G2 ) @ E2 @ ( product_Pair @ F2 @ G2 @ F3 @ G3 ) ) ) ) ) ) )
     => ( P @ X2 ) ) ).

% prod_induct7
thf(fact_56_prod__induct6,axiom,
    ! [F2: $tType,E: $tType,D2: $tType,C: $tType,B: $tType,A: $tType,P: ( product_prod @ A @ ( product_prod @ B @ ( product_prod @ C @ ( product_prod @ D2 @ ( product_prod @ E @ F2 ) ) ) ) ) > $o,X2: product_prod @ A @ ( product_prod @ B @ ( product_prod @ C @ ( product_prod @ D2 @ ( product_prod @ E @ F2 ) ) ) )] :
      ( ! [A6: A,B7: B,C5: C,D3: D2,E2: E,F3: F2] : ( P @ ( product_Pair @ A @ ( product_prod @ B @ ( product_prod @ C @ ( product_prod @ D2 @ ( product_prod @ E @ F2 ) ) ) ) @ A6 @ ( product_Pair @ B @ ( product_prod @ C @ ( product_prod @ D2 @ ( product_prod @ E @ F2 ) ) ) @ B7 @ ( product_Pair @ C @ ( product_prod @ D2 @ ( product_prod @ E @ F2 ) ) @ C5 @ ( product_Pair @ D2 @ ( product_prod @ E @ F2 ) @ D3 @ ( product_Pair @ E @ F2 @ E2 @ F3 ) ) ) ) ) )
     => ( P @ X2 ) ) ).

% prod_induct6
thf(fact_57_prod__induct5,axiom,
    ! [E: $tType,D2: $tType,C: $tType,B: $tType,A: $tType,P: ( product_prod @ A @ ( product_prod @ B @ ( product_prod @ C @ ( product_prod @ D2 @ E ) ) ) ) > $o,X2: product_prod @ A @ ( product_prod @ B @ ( product_prod @ C @ ( product_prod @ D2 @ E ) ) )] :
      ( ! [A6: A,B7: B,C5: C,D3: D2,E2: E] : ( P @ ( product_Pair @ A @ ( product_prod @ B @ ( product_prod @ C @ ( product_prod @ D2 @ E ) ) ) @ A6 @ ( product_Pair @ B @ ( product_prod @ C @ ( product_prod @ D2 @ E ) ) @ B7 @ ( product_Pair @ C @ ( product_prod @ D2 @ E ) @ C5 @ ( product_Pair @ D2 @ E @ D3 @ E2 ) ) ) ) )
     => ( P @ X2 ) ) ).

% prod_induct5
thf(fact_58_bot__set__def,axiom,
    ! [A: $tType] :
      ( ( bot_bot @ ( set @ A ) )
      = ( collect @ A @ ( bot_bot @ ( A > $o ) ) ) ) ).

% bot_set_def
thf(fact_59_is__singleton__the__elem,axiom,
    ! [A: $tType] :
      ( ( is_singleton @ A )
      = ( ^ [A7: set @ A] :
            ( A7
            = ( insert @ A @ ( the_elem @ A @ A7 ) @ ( bot_bot @ ( set @ A ) ) ) ) ) ) ).

% is_singleton_the_elem
thf(fact_60_is__singletonI_H,axiom,
    ! [A: $tType,A3: set @ A] :
      ( ( A3
       != ( bot_bot @ ( set @ A ) ) )
     => ( ! [X3: A,Y2: A] :
            ( ( member @ A @ X3 @ A3 )
           => ( ( member @ A @ Y2 @ A3 )
             => ( X3 = Y2 ) ) )
       => ( is_singleton @ A @ A3 ) ) ) ).

% is_singletonI'
thf(fact_61_surj__pair,axiom,
    ! [A: $tType,B: $tType,P3: product_prod @ A @ B] :
    ? [X3: A,Y2: B] :
      ( P3
      = ( product_Pair @ A @ B @ X3 @ Y2 ) ) ).

% surj_pair
thf(fact_62_prod__cases,axiom,
    ! [B: $tType,A: $tType,P: ( product_prod @ A @ B ) > $o,P3: product_prod @ A @ B] :
      ( ! [A6: A,B7: B] : ( P @ ( product_Pair @ A @ B @ A6 @ B7 ) )
     => ( P @ P3 ) ) ).

% prod_cases
thf(fact_63_Pair__inject,axiom,
    ! [A: $tType,B: $tType,A2: A,B3: B,A5: A,B6: B] :
      ( ( ( product_Pair @ A @ B @ A2 @ B3 )
        = ( product_Pair @ A @ B @ A5 @ B6 ) )
     => ~ ( ( A2 = A5 )
         => ( B3 != B6 ) ) ) ).

% Pair_inject
thf(fact_64_old_Oprod_Oexhaust,axiom,
    ! [A: $tType,B: $tType,Y3: product_prod @ A @ B] :
      ~ ! [A6: A,B7: B] :
          ( Y3
         != ( product_Pair @ A @ B @ A6 @ B7 ) ) ).

% old.prod.exhaust
thf(fact_65_old_Oprod_Oinducts,axiom,
    ! [B: $tType,A: $tType,P: ( product_prod @ A @ B ) > $o,Prod: product_prod @ A @ B] :
      ( ! [A6: A,B7: B] : ( P @ ( product_Pair @ A @ B @ A6 @ B7 ) )
     => ( P @ Prod ) ) ).

% old.prod.inducts
thf(fact_66_bot__fun__def,axiom,
    ! [B: $tType,A: $tType] :
      ( ( bot @ B )
     => ( ( bot_bot @ ( A > B ) )
        = ( ^ [X: A] : ( bot_bot @ B ) ) ) ) ).

% bot_fun_def
thf(fact_67_is__singletonE,axiom,
    ! [A: $tType,A3: set @ A] :
      ( ( is_singleton @ A @ A3 )
     => ~ ! [X3: A] :
            ( A3
           != ( insert @ A @ X3 @ ( bot_bot @ ( set @ A ) ) ) ) ) ).

% is_singletonE
thf(fact_68_is__singleton__def,axiom,
    ! [A: $tType] :
      ( ( is_singleton @ A )
      = ( ^ [A7: set @ A] :
          ? [X: A] :
            ( A7
            = ( insert @ A @ X @ ( bot_bot @ ( set @ A ) ) ) ) ) ) ).

% is_singleton_def
thf(fact_69_wf__def,axiom,
    ! [A: $tType] :
      ( ( wf @ A )
      = ( ^ [R3: set @ ( product_prod @ A @ A )] :
          ! [P4: A > $o] :
            ( ! [X: A] :
                ( ! [Y5: A] :
                    ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ Y5 @ X ) @ R3 )
                   => ( P4 @ Y5 ) )
               => ( P4 @ X ) )
           => ! [X4: A] : ( P4 @ X4 ) ) ) ) ).

% wf_def
thf(fact_70_wfE__min,axiom,
    ! [A: $tType,R2: set @ ( product_prod @ A @ A ),X2: A,Q: set @ A] :
      ( ( wf @ A @ R2 )
     => ( ( member @ A @ X2 @ Q )
       => ~ ! [Z: A] :
              ( ( member @ A @ Z @ Q )
             => ~ ! [Y4: A] :
                    ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ Y4 @ Z ) @ R2 )
                   => ~ ( member @ A @ Y4 @ Q ) ) ) ) ) ).

% wfE_min
thf(fact_71_wfI__min,axiom,
    ! [A: $tType,R2: set @ ( product_prod @ A @ A )] :
      ( ! [X3: A,Q3: set @ A] :
          ( ( member @ A @ X3 @ Q3 )
         => ? [Xa: A] :
              ( ( member @ A @ Xa @ Q3 )
              & ! [Y2: A] :
                  ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ Y2 @ Xa ) @ R2 )
                 => ~ ( member @ A @ Y2 @ Q3 ) ) ) )
     => ( wf @ A @ R2 ) ) ).

% wfI_min
thf(fact_72_wfUNIVI,axiom,
    ! [A: $tType,R: set @ ( product_prod @ A @ A )] :
      ( ! [P5: A > $o,X3: A] :
          ( ! [Xa: A] :
              ( ! [Y2: A] :
                  ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ Y2 @ Xa ) @ R )
                 => ( P5 @ Y2 ) )
             => ( P5 @ Xa ) )
         => ( P5 @ X3 ) )
     => ( wf @ A @ R ) ) ).

% wfUNIVI
thf(fact_73_wf__asym,axiom,
    ! [A: $tType,R: set @ ( product_prod @ A @ A ),A2: A,X2: A] :
      ( ( wf @ A @ R )
     => ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A2 @ X2 ) @ R )
       => ~ ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ X2 @ A2 ) @ R ) ) ) ).

% wf_asym
thf(fact_74_wf__induct,axiom,
    ! [A: $tType,R: set @ ( product_prod @ A @ A ),P: A > $o,A2: A] :
      ( ( wf @ A @ R )
     => ( ! [X3: A] :
            ( ! [Y4: A] :
                ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ Y4 @ X3 ) @ R )
               => ( P @ Y4 ) )
           => ( P @ X3 ) )
       => ( P @ A2 ) ) ) ).

% wf_induct
thf(fact_75_wf__irrefl,axiom,
    ! [A: $tType,R: set @ ( product_prod @ A @ A ),A2: A] :
      ( ( wf @ A @ R )
     => ~ ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A2 @ A2 ) @ R ) ) ).

% wf_irrefl
thf(fact_76_wf__not__sym,axiom,
    ! [A: $tType,R: set @ ( product_prod @ A @ A ),A2: A,X2: A] :
      ( ( wf @ A @ R )
     => ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A2 @ X2 ) @ R )
       => ~ ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ X2 @ A2 ) @ R ) ) ) ).

% wf_not_sym
thf(fact_77_wf__not__refl,axiom,
    ! [A: $tType,R: set @ ( product_prod @ A @ A ),A2: A] :
      ( ( wf @ A @ R )
     => ~ ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A2 @ A2 ) @ R ) ) ).

% wf_not_refl
thf(fact_78_wf__eq__minimal,axiom,
    ! [A: $tType] :
      ( ( wf @ A )
      = ( ^ [R3: set @ ( product_prod @ A @ A )] :
          ! [Q4: set @ A] :
            ( ? [X: A] : ( member @ A @ X @ Q4 )
           => ? [X: A] :
                ( ( member @ A @ X @ Q4 )
                & ! [Y5: A] :
                    ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ Y5 @ X ) @ R3 )
                   => ~ ( member @ A @ Y5 @ Q4 ) ) ) ) ) ) ).

% wf_eq_minimal
thf(fact_79_wf__induct__rule,axiom,
    ! [A: $tType,R: set @ ( product_prod @ A @ A ),P: A > $o,A2: A] :
      ( ( wf @ A @ R )
     => ( ! [X3: A] :
            ( ! [Y4: A] :
                ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ Y4 @ X3 ) @ R )
               => ( P @ Y4 ) )
           => ( P @ X3 ) )
       => ( P @ A2 ) ) ) ).

% wf_induct_rule
thf(fact_80_prod__cases3,axiom,
    ! [A: $tType,B: $tType,C: $tType,Y3: product_prod @ A @ ( product_prod @ B @ C )] :
      ~ ! [A6: A,B7: B,C5: C] :
          ( Y3
         != ( product_Pair @ A @ ( product_prod @ B @ C ) @ A6 @ ( product_Pair @ B @ C @ B7 @ C5 ) ) ) ).

% prod_cases3
thf(fact_81_prod__cases4,axiom,
    ! [A: $tType,B: $tType,C: $tType,D2: $tType,Y3: product_prod @ A @ ( product_prod @ B @ ( product_prod @ C @ D2 ) )] :
      ~ ! [A6: A,B7: B,C5: C,D3: D2] :
          ( Y3
         != ( product_Pair @ A @ ( product_prod @ B @ ( product_prod @ C @ D2 ) ) @ A6 @ ( product_Pair @ B @ ( product_prod @ C @ D2 ) @ B7 @ ( product_Pair @ C @ D2 @ C5 @ D3 ) ) ) ) ).

% prod_cases4
thf(fact_82_prod__cases5,axiom,
    ! [A: $tType,B: $tType,C: $tType,D2: $tType,E: $tType,Y3: product_prod @ A @ ( product_prod @ B @ ( product_prod @ C @ ( product_prod @ D2 @ E ) ) )] :
      ~ ! [A6: A,B7: B,C5: C,D3: D2,E2: E] :
          ( Y3
         != ( product_Pair @ A @ ( product_prod @ B @ ( product_prod @ C @ ( product_prod @ D2 @ E ) ) ) @ A6 @ ( product_Pair @ B @ ( product_prod @ C @ ( product_prod @ D2 @ E ) ) @ B7 @ ( product_Pair @ C @ ( product_prod @ D2 @ E ) @ C5 @ ( product_Pair @ D2 @ E @ D3 @ E2 ) ) ) ) ) ).

% prod_cases5
thf(fact_83_prod__cases6,axiom,
    ! [A: $tType,B: $tType,C: $tType,D2: $tType,E: $tType,F2: $tType,Y3: product_prod @ A @ ( product_prod @ B @ ( product_prod @ C @ ( product_prod @ D2 @ ( product_prod @ E @ F2 ) ) ) )] :
      ~ ! [A6: A,B7: B,C5: C,D3: D2,E2: E,F3: F2] :
          ( Y3
         != ( product_Pair @ A @ ( product_prod @ B @ ( product_prod @ C @ ( product_prod @ D2 @ ( product_prod @ E @ F2 ) ) ) ) @ A6 @ ( product_Pair @ B @ ( product_prod @ C @ ( product_prod @ D2 @ ( product_prod @ E @ F2 ) ) ) @ B7 @ ( product_Pair @ C @ ( product_prod @ D2 @ ( product_prod @ E @ F2 ) ) @ C5 @ ( product_Pair @ D2 @ ( product_prod @ E @ F2 ) @ D3 @ ( product_Pair @ E @ F2 @ E2 @ F3 ) ) ) ) ) ) ).

% prod_cases6
thf(fact_84_prod__cases7,axiom,
    ! [A: $tType,B: $tType,C: $tType,D2: $tType,E: $tType,F2: $tType,G2: $tType,Y3: product_prod @ A @ ( product_prod @ B @ ( product_prod @ C @ ( product_prod @ D2 @ ( product_prod @ E @ ( product_prod @ F2 @ G2 ) ) ) ) )] :
      ~ ! [A6: A,B7: B,C5: C,D3: D2,E2: E,F3: F2,G3: G2] :
          ( Y3
         != ( product_Pair @ A @ ( product_prod @ B @ ( product_prod @ C @ ( product_prod @ D2 @ ( product_prod @ E @ ( product_prod @ F2 @ G2 ) ) ) ) ) @ A6 @ ( product_Pair @ B @ ( product_prod @ C @ ( product_prod @ D2 @ ( product_prod @ E @ ( product_prod @ F2 @ G2 ) ) ) ) @ B7 @ ( product_Pair @ C @ ( product_prod @ D2 @ ( product_prod @ E @ ( product_prod @ F2 @ G2 ) ) ) @ C5 @ ( product_Pair @ D2 @ ( product_prod @ E @ ( product_prod @ F2 @ G2 ) ) @ D3 @ ( product_Pair @ E @ ( product_prod @ F2 @ G2 ) @ E2 @ ( product_Pair @ F2 @ G2 @ F3 @ G3 ) ) ) ) ) ) ) ).

% prod_cases7
thf(fact_85_prod__induct3,axiom,
    ! [C: $tType,B: $tType,A: $tType,P: ( product_prod @ A @ ( product_prod @ B @ C ) ) > $o,X2: product_prod @ A @ ( product_prod @ B @ C )] :
      ( ! [A6: A,B7: B,C5: C] : ( P @ ( product_Pair @ A @ ( product_prod @ B @ C ) @ A6 @ ( product_Pair @ B @ C @ B7 @ C5 ) ) )
     => ( P @ X2 ) ) ).

% prod_induct3
thf(fact_86_prod__induct4,axiom,
    ! [D2: $tType,C: $tType,B: $tType,A: $tType,P: ( product_prod @ A @ ( product_prod @ B @ ( product_prod @ C @ D2 ) ) ) > $o,X2: product_prod @ A @ ( product_prod @ B @ ( product_prod @ C @ D2 ) )] :
      ( ! [A6: A,B7: B,C5: C,D3: D2] : ( P @ ( product_Pair @ A @ ( product_prod @ B @ ( product_prod @ C @ D2 ) ) @ A6 @ ( product_Pair @ B @ ( product_prod @ C @ D2 ) @ B7 @ ( product_Pair @ C @ D2 @ C5 @ D3 ) ) ) )
     => ( P @ X2 ) ) ).

% prod_induct4
thf(fact_87_old_Oprod_Orec,axiom,
    ! [A: $tType,T: $tType,B: $tType,F1: A > B > T,A2: A,B3: B] :
      ( ( product_rec_prod @ A @ B @ T @ F1 @ ( product_Pair @ A @ B @ A2 @ B3 ) )
      = ( F1 @ A2 @ B3 ) ) ).

% old.prod.rec
thf(fact_88_bot__empty__eq2,axiom,
    ! [B: $tType,A: $tType] :
      ( ( bot_bot @ ( A > B > $o ) )
      = ( ^ [X: A,Y5: B] : ( member @ ( product_prod @ A @ B ) @ ( product_Pair @ A @ B @ X @ Y5 ) @ ( bot_bot @ ( set @ ( product_prod @ A @ B ) ) ) ) ) ) ).

% bot_empty_eq2
thf(fact_89_wf__measure,axiom,
    ! [A: $tType,F: A > nat] : ( wf @ A @ ( measure @ A @ F ) ) ).

% wf_measure
thf(fact_90_dependent__wf__choice,axiom,
    ! [B: $tType,A: $tType,R2: set @ ( product_prod @ A @ A ),P: ( A > B ) > A > B > $o] :
      ( ( wf @ A @ R2 )
     => ( ! [F3: A > B,G3: A > B,X3: A,R4: B] :
            ( ! [Z2: A] :
                ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ Z2 @ X3 ) @ R2 )
               => ( ( F3 @ Z2 )
                  = ( G3 @ Z2 ) ) )
           => ( ( P @ F3 @ X3 @ R4 )
              = ( P @ G3 @ X3 @ R4 ) ) )
       => ( ! [X3: A,F3: A > B] :
              ( ! [Y4: A] :
                  ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ Y4 @ X3 ) @ R2 )
                 => ( P @ F3 @ Y4 @ ( F3 @ Y4 ) ) )
             => ? [X_1: B] : ( P @ F3 @ X3 @ X_1 ) )
         => ? [F3: A > B] :
            ! [X5: A] : ( P @ F3 @ X5 @ ( F3 @ X5 ) ) ) ) ) ).

% dependent_wf_choice
thf(fact_91_thoare_OWhile,axiom,
    ! [A: $tType,R: set @ ( product_prod @ state @ state ),C2: set @ ( product_prod @ ( A > state > $o ) @ ( product_prod @ com @ ( A > state > $o ) ) ),P: A > state > $o,B3: state > $o,C3: com] :
      ( ( wf @ state @ R )
     => ( ! [S3: state] :
            ( pHoare166426476thoare @ A @ C2
            @ ^ [Z4: A,S4: state] :
                ( ( P @ Z4 @ S4 )
                & ( B3 @ S4 )
                & ( S3 = S4 ) )
            @ C3
            @ ^ [Z4: A,S4: state] :
                ( ( P @ Z4 @ S4 )
                & ( member @ ( product_prod @ state @ state ) @ ( product_Pair @ state @ state @ S4 @ S3 ) @ R ) ) )
       => ( pHoare166426476thoare @ A @ C2 @ P @ ( while @ B3 @ C3 )
          @ ^ [Z4: A,S4: state] :
              ( ( P @ Z4 @ S4 )
              & ~ ( B3 @ S4 ) ) ) ) ) ).

% thoare.While
thf(fact_92_hoare__sound,axiom,
    ! [A: $tType,C2: set @ ( product_prod @ ( A > state > $o ) @ ( product_prod @ com @ ( A > state > $o ) ) ),P: A > state > $o,C3: com,Q: A > state > $o] :
      ( ( hoare @ A @ C2 @ P @ C3 @ Q )
     => ( cvalid @ A @ C2 @ P @ C3 @ Q ) ) ).

% hoare_sound
thf(fact_93_Set_Ois__empty__def,axiom,
    ! [A: $tType] :
      ( ( is_empty @ A )
      = ( ^ [A7: set @ A] :
            ( A7
            = ( bot_bot @ ( set @ A ) ) ) ) ) ).

% Set.is_empty_def
thf(fact_94_com_Oinject_I4_J,axiom,
    ! [X41: state > $o,X42: com,Y41: state > $o,Y42: com] :
      ( ( ( while @ X41 @ X42 )
        = ( while @ Y41 @ Y42 ) )
      = ( ( X41 = Y41 )
        & ( X42 = Y42 ) ) ) ).

% com.inject(4)
thf(fact_95_bot2E,axiom,
    ! [A: $tType,B: $tType,X2: A,Y3: B] :
      ~ ( bot_bot @ ( A > B > $o ) @ X2 @ Y3 ) ).

% bot2E
thf(fact_96_com_Odistinct_I25_J,axiom,
    ! [X41: state > $o,X42: com] :
      ( ( while @ X41 @ X42 )
     != call ) ).

% com.distinct(25)
thf(fact_97_exec_OWhileFalse,axiom,
    ! [B3: state > $o,S2: state,C3: com] :
      ( ~ ( B3 @ S2 )
     => ( exec @ S2 @ ( while @ B3 @ C3 ) @ S2 ) ) ).

% exec.WhileFalse
thf(fact_98_exec_OWhileTrue,axiom,
    ! [B3: state > $o,S2: state,C3: com,T3: state,U2: state] :
      ( ( B3 @ S2 )
     => ( ( exec @ S2 @ C3 @ T3 )
       => ( ( exec @ T3 @ ( while @ B3 @ C3 ) @ U2 )
         => ( exec @ S2 @ ( while @ B3 @ C3 ) @ U2 ) ) ) ) ).

% exec.WhileTrue
thf(fact_99_termi_OWhileFalse,axiom,
    ! [B3: state > $o,S2: state,C3: com] :
      ( ~ ( B3 @ S2 )
     => ( termi @ ( while @ B3 @ C3 ) @ S2 ) ) ).

% termi.WhileFalse
thf(fact_100_hoare_OWhile,axiom,
    ! [A: $tType,C2: set @ ( product_prod @ ( A > state > $o ) @ ( product_prod @ com @ ( A > state > $o ) ) ),P: A > state > $o,B3: state > $o,C3: com] :
      ( ( hoare @ A @ C2
        @ ^ [Z4: A,S4: state] :
            ( ( P @ Z4 @ S4 )
            & ( B3 @ S4 ) )
        @ C3
        @ P )
     => ( hoare @ A @ C2 @ P @ ( while @ B3 @ C3 )
        @ ^ [Z4: A,S4: state] :
            ( ( P @ Z4 @ S4 )
            & ~ ( B3 @ S4 ) ) ) ) ).

% hoare.While
thf(fact_101_termi_OWhileTrue,axiom,
    ! [B3: state > $o,S2: state,C3: com] :
      ( ( B3 @ S2 )
     => ( ( termi @ C3 @ S2 )
       => ( ! [T2: state] :
              ( ( exec @ S2 @ C3 @ T2 )
             => ( termi @ ( while @ B3 @ C3 ) @ T2 ) )
         => ( termi @ ( while @ B3 @ C3 ) @ S2 ) ) ) ) ).

% termi.WhileTrue
thf(fact_102_bot__empty__eq,axiom,
    ! [A: $tType] :
      ( ( bot_bot @ ( A > $o ) )
      = ( ^ [X: A] : ( member @ A @ X @ ( bot_bot @ ( set @ A ) ) ) ) ) ).

% bot_empty_eq
thf(fact_103_pred__equals__eq2,axiom,
    ! [B: $tType,A: $tType,R2: set @ ( product_prod @ A @ B ),S5: set @ ( product_prod @ A @ B )] :
      ( ( ( ^ [X: A,Y5: B] : ( member @ ( product_prod @ A @ B ) @ ( product_Pair @ A @ B @ X @ Y5 ) @ R2 ) )
        = ( ^ [X: A,Y5: B] : ( member @ ( product_prod @ A @ B ) @ ( product_Pair @ A @ B @ X @ Y5 ) @ S5 ) ) )
      = ( R2 = S5 ) ) ).

% pred_equals_eq2
thf(fact_104_Collect__empty__eq__bot,axiom,
    ! [A: $tType,P: A > $o] :
      ( ( ( collect @ A @ P )
        = ( bot_bot @ ( set @ A ) ) )
      = ( P
        = ( bot_bot @ ( A > $o ) ) ) ) ).

% Collect_empty_eq_bot
thf(fact_105_total__on__singleton,axiom,
    ! [A: $tType,X2: A] : ( total_on @ A @ ( insert @ A @ X2 @ ( bot_bot @ ( set @ A ) ) ) @ ( insert @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ X2 @ X2 ) @ ( bot_bot @ ( set @ ( product_prod @ A @ A ) ) ) ) ) ).

% total_on_singleton
thf(fact_106_refl__on__singleton,axiom,
    ! [A: $tType,X2: A] : ( refl_on @ A @ ( insert @ A @ X2 @ ( bot_bot @ ( set @ A ) ) ) @ ( insert @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ X2 @ X2 ) @ ( bot_bot @ ( set @ ( product_prod @ A @ A ) ) ) ) ) ).

% refl_on_singleton
thf(fact_107_wf__termi,axiom,
    ! [B3: state > $o,C3: com] :
      ( wf @ state
      @ ( collect @ ( product_prod @ state @ state )
        @ ( product_case_prod @ state @ state @ $o
          @ ^ [T4: state,S4: state] :
              ( ( termi @ ( while @ B3 @ C3 ) @ S4 )
              & ( B3 @ S4 )
              & ( exec @ S4 @ C3 @ T4 ) ) ) ) ) ).

% wf_termi
thf(fact_108_linear__order__on__singleton,axiom,
    ! [A: $tType,X2: A] : ( order_1409979114der_on @ A @ ( insert @ A @ X2 @ ( bot_bot @ ( set @ A ) ) ) @ ( insert @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ X2 @ X2 ) @ ( bot_bot @ ( set @ ( product_prod @ A @ A ) ) ) ) ) ).

% linear_order_on_singleton
thf(fact_109_split__part,axiom,
    ! [B: $tType,A: $tType,P: $o,Q: A > B > $o] :
      ( ( product_case_prod @ A @ B @ $o
        @ ^ [A4: A,B8: B] :
            ( P
            & ( Q @ A4 @ B8 ) ) )
      = ( ^ [Ab: product_prod @ A @ B] :
            ( P
            & ( product_case_prod @ A @ B @ $o @ Q @ Ab ) ) ) ) ).

% split_part
thf(fact_110_case__prod__conv,axiom,
    ! [B: $tType,A: $tType,C: $tType,F: B > C > A,A2: B,B3: C] :
      ( ( product_case_prod @ B @ C @ A @ F @ ( product_Pair @ B @ C @ A2 @ B3 ) )
      = ( F @ A2 @ B3 ) ) ).

% case_prod_conv
thf(fact_111_case__prodI,axiom,
    ! [A: $tType,B: $tType,F: A > B > $o,A2: A,B3: B] :
      ( ( F @ A2 @ B3 )
     => ( product_case_prod @ A @ B @ $o @ F @ ( product_Pair @ A @ B @ A2 @ B3 ) ) ) ).

% case_prodI
thf(fact_112_case__prodI2,axiom,
    ! [B: $tType,A: $tType,P3: product_prod @ A @ B,C3: A > B > $o] :
      ( ! [A6: A,B7: B] :
          ( ( P3
            = ( product_Pair @ A @ B @ A6 @ B7 ) )
         => ( C3 @ A6 @ B7 ) )
     => ( product_case_prod @ A @ B @ $o @ C3 @ P3 ) ) ).

% case_prodI2
thf(fact_113_refl__on__domain,axiom,
    ! [A: $tType,A3: set @ A,R: set @ ( product_prod @ A @ A ),A2: A,B3: A] :
      ( ( refl_on @ A @ A3 @ R )
     => ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A2 @ B3 ) @ R )
       => ( ( member @ A @ A2 @ A3 )
          & ( member @ A @ B3 @ A3 ) ) ) ) ).

% refl_on_domain
thf(fact_114_prod_Ocase__distrib,axiom,
    ! [C: $tType,D2: $tType,B: $tType,A: $tType,H: C > D2,F: A > B > C,Prod: product_prod @ A @ B] :
      ( ( H @ ( product_case_prod @ A @ B @ C @ F @ Prod ) )
      = ( product_case_prod @ A @ B @ D2
        @ ^ [X12: A,X23: B] : ( H @ ( F @ X12 @ X23 ) )
        @ Prod ) ) ).

% prod.case_distrib
thf(fact_115_prod_Odisc__eq__case,axiom,
    ! [B: $tType,A: $tType,Prod: product_prod @ A @ B] :
      ( product_case_prod @ A @ B @ $o
      @ ^ [Uu: A,Uv: B] : $true
      @ Prod ) ).

% prod.disc_eq_case
thf(fact_116_old_Oprod_Ocase,axiom,
    ! [A: $tType,C: $tType,B: $tType,F: A > B > C,X1: A,X22: B] :
      ( ( product_case_prod @ A @ B @ C @ F @ ( product_Pair @ A @ B @ X1 @ X22 ) )
      = ( F @ X1 @ X22 ) ) ).

% old.prod.case
thf(fact_117_refl__onD2,axiom,
    ! [A: $tType,A3: set @ A,R: set @ ( product_prod @ A @ A ),X2: A,Y3: A] :
      ( ( refl_on @ A @ A3 @ R )
     => ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ X2 @ Y3 ) @ R )
       => ( member @ A @ Y3 @ A3 ) ) ) ).

% refl_onD2
thf(fact_118_refl__onD1,axiom,
    ! [A: $tType,A3: set @ A,R: set @ ( product_prod @ A @ A ),X2: A,Y3: A] :
      ( ( refl_on @ A @ A3 @ R )
     => ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ X2 @ Y3 ) @ R )
       => ( member @ A @ X2 @ A3 ) ) ) ).

% refl_onD1
thf(fact_119_refl__onD,axiom,
    ! [A: $tType,A3: set @ A,R: set @ ( product_prod @ A @ A ),A2: A] :
      ( ( refl_on @ A @ A3 @ R )
     => ( ( member @ A @ A2 @ A3 )
       => ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A2 @ A2 ) @ R ) ) ) ).

% refl_onD
thf(fact_120_case__prodD,axiom,
    ! [A: $tType,B: $tType,F: A > B > $o,A2: A,B3: B] :
      ( ( product_case_prod @ A @ B @ $o @ F @ ( product_Pair @ A @ B @ A2 @ B3 ) )
     => ( F @ A2 @ B3 ) ) ).

% case_prodD
thf(fact_121_case__prodE,axiom,
    ! [A: $tType,B: $tType,C3: A > B > $o,P3: product_prod @ A @ B] :
      ( ( product_case_prod @ A @ B @ $o @ C3 @ P3 )
     => ~ ! [X3: A,Y2: B] :
            ( ( P3
              = ( product_Pair @ A @ B @ X3 @ Y2 ) )
           => ~ ( C3 @ X3 @ Y2 ) ) ) ).

% case_prodE
thf(fact_122_total__on__def,axiom,
    ! [A: $tType] :
      ( ( total_on @ A )
      = ( ^ [A7: set @ A,R3: set @ ( product_prod @ A @ A )] :
          ! [X: A] :
            ( ( member @ A @ X @ A7 )
           => ! [Y5: A] :
                ( ( member @ A @ Y5 @ A7 )
               => ( ( X != Y5 )
                 => ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ X @ Y5 ) @ R3 )
                    | ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ Y5 @ X ) @ R3 ) ) ) ) ) ) ) ).

% total_on_def
thf(fact_123_total__onI,axiom,
    ! [A: $tType,A3: set @ A,R: set @ ( product_prod @ A @ A )] :
      ( ! [X3: A,Y2: A] :
          ( ( member @ A @ X3 @ A3 )
         => ( ( member @ A @ Y2 @ A3 )
           => ( ( X3 != Y2 )
             => ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ X3 @ Y2 ) @ R )
                | ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ Y2 @ X3 ) @ R ) ) ) ) )
     => ( total_on @ A @ A3 @ R ) ) ).

% total_onI
thf(fact_124_total__on__empty,axiom,
    ! [A: $tType,R: set @ ( product_prod @ A @ A )] : ( total_on @ A @ ( bot_bot @ ( set @ A ) ) @ R ) ).

% total_on_empty
thf(fact_125_case__prodE2,axiom,
    ! [B: $tType,A: $tType,C: $tType,Q: A > $o,P: B > C > A,Z5: product_prod @ B @ C] :
      ( ( Q @ ( product_case_prod @ B @ C @ A @ P @ Z5 ) )
     => ~ ! [X3: B,Y2: C] :
            ( ( Z5
              = ( product_Pair @ B @ C @ X3 @ Y2 ) )
           => ~ ( Q @ ( P @ X3 @ Y2 ) ) ) ) ).

% case_prodE2
thf(fact_126_case__prod__eta,axiom,
    ! [C: $tType,B: $tType,A: $tType,F: ( product_prod @ A @ B ) > C] :
      ( ( product_case_prod @ A @ B @ C
        @ ^ [X: A,Y5: B] : ( F @ ( product_Pair @ A @ B @ X @ Y5 ) ) )
      = F ) ).

% case_prod_eta
thf(fact_127_cond__case__prod__eta,axiom,
    ! [C: $tType,B: $tType,A: $tType,F: A > B > C,G: ( product_prod @ A @ B ) > C] :
      ( ! [X3: A,Y2: B] :
          ( ( F @ X3 @ Y2 )
          = ( G @ ( product_Pair @ A @ B @ X3 @ Y2 ) ) )
     => ( ( product_case_prod @ A @ B @ C @ F )
        = G ) ) ).

% cond_case_prod_eta
thf(fact_128_lnear__order__on__empty,axiom,
    ! [A: $tType] : ( order_1409979114der_on @ A @ ( bot_bot @ ( set @ A ) ) @ ( bot_bot @ ( set @ ( product_prod @ A @ A ) ) ) ) ).

% lnear_order_on_empty
thf(fact_129_refl__on__empty,axiom,
    ! [A: $tType] : ( refl_on @ A @ ( bot_bot @ ( set @ A ) ) @ ( bot_bot @ ( set @ ( product_prod @ A @ A ) ) ) ) ).

% refl_on_empty
thf(fact_130_split__cong,axiom,
    ! [C: $tType,B: $tType,A: $tType,Q5: product_prod @ A @ B,F: A > B > C,G: A > B > C,P3: product_prod @ A @ B] :
      ( ! [X3: A,Y2: B] :
          ( ( ( product_Pair @ A @ B @ X3 @ Y2 )
            = Q5 )
         => ( ( F @ X3 @ Y2 )
            = ( G @ X3 @ Y2 ) ) )
     => ( ( P3 = Q5 )
       => ( ( product_case_prod @ A @ B @ C @ F @ P3 )
          = ( product_case_prod @ A @ B @ C @ G @ Q5 ) ) ) ) ).

% split_cong
thf(fact_131_aboveS__def,axiom,
    ! [A: $tType] :
      ( ( order_aboveS @ A )
      = ( ^ [R3: set @ ( product_prod @ A @ A ),A4: A] :
            ( collect @ A
            @ ^ [B8: A] :
                ( ( B8 != A4 )
                & ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A4 @ B8 ) @ R3 ) ) ) ) ) ).

% aboveS_def
thf(fact_132_case__prod__app,axiom,
    ! [A: $tType,D2: $tType,C: $tType,B: $tType] :
      ( ( product_case_prod @ B @ C @ ( D2 > A ) )
      = ( ^ [F4: B > C > D2 > A,X: product_prod @ B @ C,Y5: D2] :
            ( product_case_prod @ B @ C @ A
            @ ^ [L: B,R3: C] : ( F4 @ L @ R3 @ Y5 )
            @ X ) ) ) ).

% case_prod_app
thf(fact_133_internal__case__prod__def,axiom,
    ! [C: $tType,B: $tType,A: $tType] :
      ( ( produc2004651681e_prod @ A @ B @ C )
      = ( product_case_prod @ A @ B @ C ) ) ).

% internal_case_prod_def
thf(fact_134_internal__case__prod__conv,axiom,
    ! [B: $tType,A: $tType,C: $tType,C3: B > C > A,A2: B,B3: C] :
      ( ( produc2004651681e_prod @ B @ C @ A @ C3 @ ( product_Pair @ B @ C @ A2 @ B3 ) )
      = ( C3 @ A2 @ B3 ) ) ).

% internal_case_prod_conv
thf(fact_135_mem__case__prodI2,axiom,
    ! [C: $tType,B: $tType,A: $tType,P3: product_prod @ A @ B,Z5: C,C3: A > B > ( set @ C )] :
      ( ! [A6: A,B7: B] :
          ( ( P3
            = ( product_Pair @ A @ B @ A6 @ B7 ) )
         => ( member @ C @ Z5 @ ( C3 @ A6 @ B7 ) ) )
     => ( member @ C @ Z5 @ ( product_case_prod @ A @ B @ ( set @ C ) @ C3 @ P3 ) ) ) ).

% mem_case_prodI2
thf(fact_136_mem__case__prodI,axiom,
    ! [A: $tType,B: $tType,C: $tType,Z5: A,C3: B > C > ( set @ A ),A2: B,B3: C] :
      ( ( member @ A @ Z5 @ ( C3 @ A2 @ B3 ) )
     => ( member @ A @ Z5 @ ( product_case_prod @ B @ C @ ( set @ A ) @ C3 @ ( product_Pair @ B @ C @ A2 @ B3 ) ) ) ) ).

% mem_case_prodI
thf(fact_137_case__prodI2_H,axiom,
    ! [A: $tType,B: $tType,C: $tType,P3: product_prod @ A @ B,C3: A > B > C > $o,X2: C] :
      ( ! [A6: A,B7: B] :
          ( ( ( product_Pair @ A @ B @ A6 @ B7 )
            = P3 )
         => ( C3 @ A6 @ B7 @ X2 ) )
     => ( product_case_prod @ A @ B @ ( C > $o ) @ C3 @ P3 @ X2 ) ) ).

% case_prodI2'
thf(fact_138_case__prod__Pair__iden,axiom,
    ! [B: $tType,A: $tType,P3: product_prod @ A @ B] :
      ( ( product_case_prod @ A @ B @ ( product_prod @ A @ B ) @ ( product_Pair @ A @ B ) @ P3 )
      = P3 ) ).

% case_prod_Pair_iden
thf(fact_139_mem__case__prodE,axiom,
    ! [B: $tType,A: $tType,C: $tType,Z5: A,C3: B > C > ( set @ A ),P3: product_prod @ B @ C] :
      ( ( member @ A @ Z5 @ ( product_case_prod @ B @ C @ ( set @ A ) @ C3 @ P3 ) )
     => ~ ! [X3: B,Y2: C] :
            ( ( P3
              = ( product_Pair @ B @ C @ X3 @ Y2 ) )
           => ~ ( member @ A @ Z5 @ ( C3 @ X3 @ Y2 ) ) ) ) ).

% mem_case_prodE
thf(fact_140_case__prodE_H,axiom,
    ! [B: $tType,A: $tType,C: $tType,C3: A > B > C > $o,P3: product_prod @ A @ B,Z5: C] :
      ( ( product_case_prod @ A @ B @ ( C > $o ) @ C3 @ P3 @ Z5 )
     => ~ ! [X3: A,Y2: B] :
            ( ( P3
              = ( product_Pair @ A @ B @ X3 @ Y2 ) )
           => ~ ( C3 @ X3 @ Y2 @ Z5 ) ) ) ).

% case_prodE'
thf(fact_141_case__prodD_H,axiom,
    ! [B: $tType,A: $tType,C: $tType,R2: A > B > C > $o,A2: A,B3: B,C3: C] :
      ( ( product_case_prod @ A @ B @ ( C > $o ) @ R2 @ ( product_Pair @ A @ B @ A2 @ B3 ) @ C3 )
     => ( R2 @ A2 @ B3 @ C3 ) ) ).

% case_prodD'
thf(fact_142_lex__prod__def,axiom,
    ! [B: $tType,A: $tType] :
      ( ( lex_prod @ A @ B )
      = ( ^ [Ra: set @ ( product_prod @ A @ A ),Rb: set @ ( product_prod @ B @ B )] :
            ( collect @ ( product_prod @ ( product_prod @ A @ B ) @ ( product_prod @ A @ B ) )
            @ ( product_case_prod @ ( product_prod @ A @ B ) @ ( product_prod @ A @ B ) @ $o
              @ ( product_case_prod @ A @ B @ ( ( product_prod @ A @ B ) > $o )
                @ ^ [A4: A,B8: B] :
                    ( product_case_prod @ A @ B @ $o
                    @ ^ [A8: A,B9: B] :
                        ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A4 @ A8 ) @ Ra )
                        | ( ( A4 = A8 )
                          & ( member @ ( product_prod @ B @ B ) @ ( product_Pair @ B @ B @ B8 @ B9 ) @ Rb ) ) ) ) ) ) ) ) ) ).

% lex_prod_def
thf(fact_143_prod__set__simps_I1_J,axiom,
    ! [B: $tType,A: $tType,X2: A,Y3: B] :
      ( ( basic_fsts @ A @ B @ ( product_Pair @ A @ B @ X2 @ Y3 ) )
      = ( insert @ A @ X2 @ ( bot_bot @ ( set @ A ) ) ) ) ).

% prod_set_simps(1)
thf(fact_144_prod__set__simps_I2_J,axiom,
    ! [A: $tType,B: $tType,X2: A,Y3: B] :
      ( ( basic_snds @ A @ B @ ( product_Pair @ A @ B @ X2 @ Y3 ) )
      = ( insert @ B @ Y3 @ ( bot_bot @ ( set @ B ) ) ) ) ).

% prod_set_simps(2)
thf(fact_145_the__elem__def,axiom,
    ! [A: $tType] :
      ( ( the_elem @ A )
      = ( ^ [X6: set @ A] :
            ( the @ A
            @ ^ [X: A] :
                ( X6
                = ( insert @ A @ X @ ( bot_bot @ ( set @ A ) ) ) ) ) ) ) ).

% the_elem_def
thf(fact_146_in__lex__prod,axiom,
    ! [A: $tType,B: $tType,A2: A,B3: B,A5: A,B6: B,R: set @ ( product_prod @ A @ A ),S2: set @ ( product_prod @ B @ B )] :
      ( ( member @ ( product_prod @ ( product_prod @ A @ B ) @ ( product_prod @ A @ B ) ) @ ( product_Pair @ ( product_prod @ A @ B ) @ ( product_prod @ A @ B ) @ ( product_Pair @ A @ B @ A2 @ B3 ) @ ( product_Pair @ A @ B @ A5 @ B6 ) ) @ ( lex_prod @ A @ B @ R @ S2 ) )
      = ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A2 @ A5 ) @ R )
        | ( ( A2 = A5 )
          & ( member @ ( product_prod @ B @ B ) @ ( product_Pair @ B @ B @ B3 @ B6 ) @ S2 ) ) ) ) ).

% in_lex_prod
thf(fact_147_The__split__eq,axiom,
    ! [A: $tType,B: $tType,X2: A,Y3: B] :
      ( ( the @ ( product_prod @ A @ B )
        @ ( product_case_prod @ A @ B @ $o
          @ ^ [X7: A,Y6: B] :
              ( ( X2 = X7 )
              & ( Y3 = Y6 ) ) ) )
      = ( product_Pair @ A @ B @ X2 @ Y3 ) ) ).

% The_split_eq
thf(fact_148_wf__lex__prod,axiom,
    ! [A: $tType,B: $tType,Ra2: set @ ( product_prod @ A @ A ),Rb2: set @ ( product_prod @ B @ B )] :
      ( ( wf @ A @ Ra2 )
     => ( ( wf @ B @ Rb2 )
       => ( wf @ ( product_prod @ A @ B ) @ ( lex_prod @ A @ B @ Ra2 @ Rb2 ) ) ) ) ).

% wf_lex_prod
thf(fact_149_old_Orec__prod__def,axiom,
    ! [T: $tType,B: $tType,A: $tType] :
      ( ( product_rec_prod @ A @ B @ T )
      = ( ^ [F12: A > B > T,X: product_prod @ A @ B] : ( the @ T @ ( product_rec_set_prod @ A @ B @ T @ F12 @ X ) ) ) ) ).

% old.rec_prod_def
thf(fact_150_the__sym__eq__trivial,axiom,
    ! [A: $tType,X2: A] :
      ( ( the @ A
        @ ( ^ [Y: A,Z3: A] : ( Y = Z3 )
          @ X2 ) )
      = X2 ) ).

% the_sym_eq_trivial
thf(fact_151_the__eq__trivial,axiom,
    ! [A: $tType,A2: A] :
      ( ( the @ A
        @ ^ [X: A] : ( X = A2 ) )
      = A2 ) ).

% the_eq_trivial
thf(fact_152_the__equality,axiom,
    ! [A: $tType,P: A > $o,A2: A] :
      ( ( P @ A2 )
     => ( ! [X3: A] :
            ( ( P @ X3 )
           => ( X3 = A2 ) )
       => ( ( the @ A @ P )
          = A2 ) ) ) ).

% the_equality
thf(fact_153_theI,axiom,
    ! [A: $tType,P: A > $o,A2: A] :
      ( ( P @ A2 )
     => ( ! [X3: A] :
            ( ( P @ X3 )
           => ( X3 = A2 ) )
       => ( P @ ( the @ A @ P ) ) ) ) ).

% theI
thf(fact_154_theI_H,axiom,
    ! [A: $tType,P: A > $o] :
      ( ? [X5: A] :
          ( ( P @ X5 )
          & ! [Y2: A] :
              ( ( P @ Y2 )
             => ( Y2 = X5 ) ) )
     => ( P @ ( the @ A @ P ) ) ) ).

% theI'
thf(fact_155_theI2,axiom,
    ! [A: $tType,P: A > $o,A2: A,Q: A > $o] :
      ( ( P @ A2 )
     => ( ! [X3: A] :
            ( ( P @ X3 )
           => ( X3 = A2 ) )
       => ( ! [X3: A] :
              ( ( P @ X3 )
             => ( Q @ X3 ) )
         => ( Q @ ( the @ A @ P ) ) ) ) ) ).

% theI2
thf(fact_156_If__def,axiom,
    ! [A: $tType] :
      ( ( if @ A )
      = ( ^ [P4: $o,X: A,Y5: A] :
            ( the @ A
            @ ^ [Z4: A] :
                ( ( P4
                 => ( Z4 = X ) )
                & ( ~ P4
                 => ( Z4 = Y5 ) ) ) ) ) ) ).

% If_def
thf(fact_157_the1I2,axiom,
    ! [A: $tType,P: A > $o,Q: A > $o] :
      ( ? [X5: A] :
          ( ( P @ X5 )
          & ! [Y2: A] :
              ( ( P @ Y2 )
             => ( Y2 = X5 ) ) )
     => ( ! [X3: A] :
            ( ( P @ X3 )
           => ( Q @ X3 ) )
       => ( Q @ ( the @ A @ P ) ) ) ) ).

% the1I2
thf(fact_158_the1__equality,axiom,
    ! [A: $tType,P: A > $o,A2: A] :
      ( ? [X5: A] :
          ( ( P @ X5 )
          & ! [Y2: A] :
              ( ( P @ Y2 )
             => ( Y2 = X5 ) ) )
     => ( ( P @ A2 )
       => ( ( the @ A @ P )
          = A2 ) ) ) ).

% the1_equality
thf(fact_159_same__fst__def,axiom,
    ! [B: $tType,A: $tType] :
      ( ( same_fst @ A @ B )
      = ( ^ [P4: A > $o,R5: A > ( set @ ( product_prod @ B @ B ) )] :
            ( collect @ ( product_prod @ ( product_prod @ A @ B ) @ ( product_prod @ A @ B ) )
            @ ( product_case_prod @ ( product_prod @ A @ B ) @ ( product_prod @ A @ B ) @ $o
              @ ( product_case_prod @ A @ B @ ( ( product_prod @ A @ B ) > $o )
                @ ^ [X7: A,Y6: B] :
                    ( product_case_prod @ A @ B @ $o
                    @ ^ [X: A,Y5: B] :
                        ( ( X7 = X )
                        & ( P4 @ X )
                        & ( member @ ( product_prod @ B @ B ) @ ( product_Pair @ B @ B @ Y6 @ Y5 ) @ ( R5 @ X ) ) ) ) ) ) ) ) ) ).

% same_fst_def
thf(fact_160_Range__insert,axiom,
    ! [A: $tType,B: $tType,A2: B,B3: A,R: set @ ( product_prod @ B @ A )] :
      ( ( range @ B @ A @ ( insert @ ( product_prod @ B @ A ) @ ( product_Pair @ B @ A @ A2 @ B3 ) @ R ) )
      = ( insert @ A @ B3 @ ( range @ B @ A @ R ) ) ) ).

% Range_insert
thf(fact_161_same__fstI,axiom,
    ! [B: $tType,A: $tType,P: A > $o,X2: A,Y7: B,Y3: B,R2: A > ( set @ ( product_prod @ B @ B ) )] :
      ( ( P @ X2 )
     => ( ( member @ ( product_prod @ B @ B ) @ ( product_Pair @ B @ B @ Y7 @ Y3 ) @ ( R2 @ X2 ) )
       => ( member @ ( product_prod @ ( product_prod @ A @ B ) @ ( product_prod @ A @ B ) ) @ ( product_Pair @ ( product_prod @ A @ B ) @ ( product_prod @ A @ B ) @ ( product_Pair @ A @ B @ X2 @ Y7 ) @ ( product_Pair @ A @ B @ X2 @ Y3 ) ) @ ( same_fst @ A @ B @ P @ R2 ) ) ) ) ).

% same_fstI
thf(fact_162_Range__empty,axiom,
    ! [B: $tType,A: $tType] :
      ( ( range @ B @ A @ ( bot_bot @ ( set @ ( product_prod @ B @ A ) ) ) )
      = ( bot_bot @ ( set @ A ) ) ) ).

% Range_empty
thf(fact_163_Range_Oinducts,axiom,
    ! [A: $tType,B: $tType,X2: B,R: set @ ( product_prod @ A @ B ),P: B > $o] :
      ( ( member @ B @ X2 @ ( range @ A @ B @ R ) )
     => ( ! [A6: A,B7: B] :
            ( ( member @ ( product_prod @ A @ B ) @ ( product_Pair @ A @ B @ A6 @ B7 ) @ R )
           => ( P @ B7 ) )
       => ( P @ X2 ) ) ) ).

% Range.inducts
thf(fact_164_Range_Ointros,axiom,
    ! [B: $tType,A: $tType,A2: A,B3: B,R: set @ ( product_prod @ A @ B )] :
      ( ( member @ ( product_prod @ A @ B ) @ ( product_Pair @ A @ B @ A2 @ B3 ) @ R )
     => ( member @ B @ B3 @ ( range @ A @ B @ R ) ) ) ).

% Range.intros
thf(fact_165_Range_Osimps,axiom,
    ! [B: $tType,A: $tType,A2: B,R: set @ ( product_prod @ A @ B )] :
      ( ( member @ B @ A2 @ ( range @ A @ B @ R ) )
      = ( ? [A4: A,B8: B] :
            ( ( A2 = B8 )
            & ( member @ ( product_prod @ A @ B ) @ ( product_Pair @ A @ B @ A4 @ B8 ) @ R ) ) ) ) ).

% Range.simps
thf(fact_166_Range_Ocases,axiom,
    ! [B: $tType,A: $tType,A2: B,R: set @ ( product_prod @ A @ B )] :
      ( ( member @ B @ A2 @ ( range @ A @ B @ R ) )
     => ~ ! [A6: A] :
            ~ ( member @ ( product_prod @ A @ B ) @ ( product_Pair @ A @ B @ A6 @ A2 ) @ R ) ) ).

% Range.cases
thf(fact_167_Range__iff,axiom,
    ! [A: $tType,B: $tType,A2: A,R: set @ ( product_prod @ B @ A )] :
      ( ( member @ A @ A2 @ ( range @ B @ A @ R ) )
      = ( ? [Y5: B] : ( member @ ( product_prod @ B @ A ) @ ( product_Pair @ B @ A @ Y5 @ A2 ) @ R ) ) ) ).

% Range_iff
thf(fact_168_RangeE,axiom,
    ! [A: $tType,B: $tType,B3: A,R: set @ ( product_prod @ B @ A )] :
      ( ( member @ A @ B3 @ ( range @ B @ A @ R ) )
     => ~ ! [A6: B] :
            ~ ( member @ ( product_prod @ B @ A ) @ ( product_Pair @ B @ A @ A6 @ B3 ) @ R ) ) ).

% RangeE
thf(fact_169_Range__empty__iff,axiom,
    ! [A: $tType,B: $tType,R: set @ ( product_prod @ B @ A )] :
      ( ( ( range @ B @ A @ R )
        = ( bot_bot @ ( set @ A ) ) )
      = ( R
        = ( bot_bot @ ( set @ ( product_prod @ B @ A ) ) ) ) ) ).

% Range_empty_iff
thf(fact_170_wf__same__fst,axiom,
    ! [B: $tType,A: $tType,P: A > $o,R2: A > ( set @ ( product_prod @ B @ B ) )] :
      ( ! [X3: A] :
          ( ( P @ X3 )
         => ( wf @ B @ ( R2 @ X3 ) ) )
     => ( wf @ ( product_prod @ A @ B ) @ ( same_fst @ A @ B @ P @ R2 ) ) ) ).

% wf_same_fst
thf(fact_171_Rangep__Range__eq,axiom,
    ! [A: $tType,B: $tType,R: set @ ( product_prod @ A @ B )] :
      ( ( rangep @ A @ B
        @ ^ [X: A,Y5: B] : ( member @ ( product_prod @ A @ B ) @ ( product_Pair @ A @ B @ X @ Y5 ) @ R ) )
      = ( ^ [X: B] : ( member @ B @ X @ ( range @ A @ B @ R ) ) ) ) ).

% Rangep_Range_eq
thf(fact_172_Range__def,axiom,
    ! [B: $tType,A: $tType] :
      ( ( range @ A @ B )
      = ( ^ [R3: set @ ( product_prod @ A @ B )] :
            ( collect @ B
            @ ( rangep @ A @ B
              @ ^ [X: A,Y5: B] : ( member @ ( product_prod @ A @ B ) @ ( product_Pair @ A @ B @ X @ Y5 ) @ R3 ) ) ) ) ) ).

% Range_def
thf(fact_173_Domain__insert,axiom,
    ! [B: $tType,A: $tType,A2: A,B3: B,R: set @ ( product_prod @ A @ B )] :
      ( ( domain @ A @ B @ ( insert @ ( product_prod @ A @ B ) @ ( product_Pair @ A @ B @ A2 @ B3 ) @ R ) )
      = ( insert @ A @ A2 @ ( domain @ A @ B @ R ) ) ) ).

% Domain_insert
thf(fact_174_Domain__empty,axiom,
    ! [B: $tType,A: $tType] :
      ( ( domain @ A @ B @ ( bot_bot @ ( set @ ( product_prod @ A @ B ) ) ) )
      = ( bot_bot @ ( set @ A ) ) ) ).

% Domain_empty
thf(fact_175_Rangep_Oinducts,axiom,
    ! [A: $tType,B: $tType,R: A > B > $o,X2: B,P: B > $o] :
      ( ( rangep @ A @ B @ R @ X2 )
     => ( ! [A6: A,B7: B] :
            ( ( R @ A6 @ B7 )
           => ( P @ B7 ) )
       => ( P @ X2 ) ) ) ).

% Rangep.inducts
thf(fact_176_Rangep_Ointros,axiom,
    ! [A: $tType,B: $tType,R: A > B > $o,A2: A,B3: B] :
      ( ( R @ A2 @ B3 )
     => ( rangep @ A @ B @ R @ B3 ) ) ).

% Rangep.intros
thf(fact_177_Rangep_Osimps,axiom,
    ! [B: $tType,A: $tType] :
      ( ( rangep @ A @ B )
      = ( ^ [R3: A > B > $o,A4: B] :
          ? [B8: A,C6: B] :
            ( ( A4 = C6 )
            & ( R3 @ B8 @ C6 ) ) ) ) ).

% Rangep.simps
thf(fact_178_Rangep_Ocases,axiom,
    ! [A: $tType,B: $tType,R: A > B > $o,A2: B] :
      ( ( rangep @ A @ B @ R @ A2 )
     => ~ ! [A6: A] :
            ~ ( R @ A6 @ A2 ) ) ).

% Rangep.cases
thf(fact_179_RangepE,axiom,
    ! [A: $tType,B: $tType,R: A > B > $o,B3: B] :
      ( ( rangep @ A @ B @ R @ B3 )
     => ~ ! [A6: A] :
            ~ ( R @ A6 @ B3 ) ) ).

% RangepE
thf(fact_180_DomainE,axiom,
    ! [B: $tType,A: $tType,A2: A,R: set @ ( product_prod @ A @ B )] :
      ( ( member @ A @ A2 @ ( domain @ A @ B @ R ) )
     => ~ ! [B7: B] :
            ~ ( member @ ( product_prod @ A @ B ) @ ( product_Pair @ A @ B @ A2 @ B7 ) @ R ) ) ).

% DomainE
thf(fact_181_Domain__iff,axiom,
    ! [A: $tType,B: $tType,A2: A,R: set @ ( product_prod @ A @ B )] :
      ( ( member @ A @ A2 @ ( domain @ A @ B @ R ) )
      = ( ? [Y5: B] : ( member @ ( product_prod @ A @ B ) @ ( product_Pair @ A @ B @ A2 @ Y5 ) @ R ) ) ) ).

% Domain_iff
thf(fact_182_Domain_Ocases,axiom,
    ! [B: $tType,A: $tType,A2: A,R: set @ ( product_prod @ A @ B )] :
      ( ( member @ A @ A2 @ ( domain @ A @ B @ R ) )
     => ~ ! [B7: B] :
            ~ ( member @ ( product_prod @ A @ B ) @ ( product_Pair @ A @ B @ A2 @ B7 ) @ R ) ) ).

% Domain.cases
thf(fact_183_Domain_Osimps,axiom,
    ! [B: $tType,A: $tType,A2: A,R: set @ ( product_prod @ A @ B )] :
      ( ( member @ A @ A2 @ ( domain @ A @ B @ R ) )
      = ( ? [A4: A,B8: B] :
            ( ( A2 = A4 )
            & ( member @ ( product_prod @ A @ B ) @ ( product_Pair @ A @ B @ A4 @ B8 ) @ R ) ) ) ) ).

% Domain.simps
thf(fact_184_Domain_ODomainI,axiom,
    ! [B: $tType,A: $tType,A2: A,B3: B,R: set @ ( product_prod @ A @ B )] :
      ( ( member @ ( product_prod @ A @ B ) @ ( product_Pair @ A @ B @ A2 @ B3 ) @ R )
     => ( member @ A @ A2 @ ( domain @ A @ B @ R ) ) ) ).

% Domain.DomainI
thf(fact_185_Domain_Oinducts,axiom,
    ! [B: $tType,A: $tType,X2: A,R: set @ ( product_prod @ A @ B ),P: A > $o] :
      ( ( member @ A @ X2 @ ( domain @ A @ B @ R ) )
     => ( ! [A6: A,B7: B] :
            ( ( member @ ( product_prod @ A @ B ) @ ( product_Pair @ A @ B @ A6 @ B7 ) @ R )
           => ( P @ A6 ) )
       => ( P @ X2 ) ) ) ).

% Domain.inducts
thf(fact_186_Domain__empty__iff,axiom,
    ! [B: $tType,A: $tType,R: set @ ( product_prod @ A @ B )] :
      ( ( ( domain @ A @ B @ R )
        = ( bot_bot @ ( set @ A ) ) )
      = ( R
        = ( bot_bot @ ( set @ ( product_prod @ A @ B ) ) ) ) ) ).

% Domain_empty_iff
thf(fact_187_old_Orec__unit__def,axiom,
    ! [T: $tType] :
      ( ( product_rec_unit @ T )
      = ( ^ [F12: T,X: product_unit] : ( the @ T @ ( product_rec_set_unit @ T @ F12 @ X ) ) ) ) ).

% old.rec_unit_def
thf(fact_188_above__def,axiom,
    ! [A: $tType] :
      ( ( order_above @ A )
      = ( ^ [R3: set @ ( product_prod @ A @ A ),A4: A] :
            ( collect @ A
            @ ^ [B8: A] : ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A4 @ B8 ) @ R3 ) ) ) ) ).

% above_def
thf(fact_189_inv__image__def,axiom,
    ! [A: $tType,B: $tType] :
      ( ( inv_image @ B @ A )
      = ( ^ [R3: set @ ( product_prod @ B @ B ),F4: A > B] :
            ( collect @ ( product_prod @ A @ A )
            @ ( product_case_prod @ A @ A @ $o
              @ ^ [X: A,Y5: A] : ( member @ ( product_prod @ B @ B ) @ ( product_Pair @ B @ B @ ( F4 @ X ) @ ( F4 @ Y5 ) ) @ R3 ) ) ) ) ) ).

% inv_image_def
thf(fact_190_in__inv__image,axiom,
    ! [A: $tType,B: $tType,X2: A,Y3: A,R: set @ ( product_prod @ B @ B ),F: A > B] :
      ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ X2 @ Y3 ) @ ( inv_image @ B @ A @ R @ F ) )
      = ( member @ ( product_prod @ B @ B ) @ ( product_Pair @ B @ B @ ( F @ X2 ) @ ( F @ Y3 ) ) @ R ) ) ).

% in_inv_image
thf(fact_191_wf__inv__image,axiom,
    ! [B: $tType,A: $tType,R: set @ ( product_prod @ B @ B ),F: A > B] :
      ( ( wf @ B @ R )
     => ( wf @ A @ ( inv_image @ B @ A @ R @ F ) ) ) ).

% wf_inv_image
thf(fact_192_rp__inv__image__def,axiom,
    ! [B: $tType,A: $tType] :
      ( ( fun_rp_inv_image @ A @ B )
      = ( product_case_prod @ ( set @ ( product_prod @ A @ A ) ) @ ( set @ ( product_prod @ A @ A ) ) @ ( ( B > A ) > ( product_prod @ ( set @ ( product_prod @ B @ B ) ) @ ( set @ ( product_prod @ B @ B ) ) ) )
        @ ^ [R5: set @ ( product_prod @ A @ A ),S6: set @ ( product_prod @ A @ A ),F4: B > A] : ( product_Pair @ ( set @ ( product_prod @ B @ B ) ) @ ( set @ ( product_prod @ B @ B ) ) @ ( inv_image @ A @ B @ R5 @ F4 ) @ ( inv_image @ A @ B @ S6 @ F4 ) ) ) ) ).

% rp_inv_image_def
thf(fact_193_Id__on__empty,axiom,
    ! [A: $tType] :
      ( ( id_on @ A @ ( bot_bot @ ( set @ A ) ) )
      = ( bot_bot @ ( set @ ( product_prod @ A @ A ) ) ) ) ).

% Id_on_empty
thf(fact_194_Id__onI,axiom,
    ! [A: $tType,A2: A,A3: set @ A] :
      ( ( member @ A @ A2 @ A3 )
     => ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A2 @ A2 ) @ ( id_on @ A @ A3 ) ) ) ).

% Id_onI
thf(fact_195_Domain__Id__on,axiom,
    ! [A: $tType,A3: set @ A] :
      ( ( domain @ A @ A @ ( id_on @ A @ A3 ) )
      = A3 ) ).

% Domain_Id_on
thf(fact_196_Range__Id__on,axiom,
    ! [A: $tType,A3: set @ A] :
      ( ( range @ A @ A @ ( id_on @ A @ A3 ) )
      = A3 ) ).

% Range_Id_on
thf(fact_197_Id__on__def_H,axiom,
    ! [A: $tType,A3: A > $o] :
      ( ( id_on @ A @ ( collect @ A @ A3 ) )
      = ( collect @ ( product_prod @ A @ A )
        @ ( product_case_prod @ A @ A @ $o
          @ ^ [X: A,Y5: A] :
              ( ( X = Y5 )
              & ( A3 @ X ) ) ) ) ) ).

% Id_on_def'
thf(fact_198_refl__on__Id__on,axiom,
    ! [A: $tType,A3: set @ A] : ( refl_on @ A @ A3 @ ( id_on @ A @ A3 ) ) ).

% refl_on_Id_on
thf(fact_199_Id__onE,axiom,
    ! [A: $tType,C3: product_prod @ A @ A,A3: set @ A] :
      ( ( member @ ( product_prod @ A @ A ) @ C3 @ ( id_on @ A @ A3 ) )
     => ~ ! [X3: A] :
            ( ( member @ A @ X3 @ A3 )
           => ( C3
             != ( product_Pair @ A @ A @ X3 @ X3 ) ) ) ) ).

% Id_onE
thf(fact_200_Id__on__eqI,axiom,
    ! [A: $tType,A2: A,B3: A,A3: set @ A] :
      ( ( A2 = B3 )
     => ( ( member @ A @ A2 @ A3 )
       => ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A2 @ B3 ) @ ( id_on @ A @ A3 ) ) ) ) ).

% Id_on_eqI
thf(fact_201_Id__on__iff,axiom,
    ! [A: $tType,X2: A,Y3: A,A3: set @ A] :
      ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ X2 @ Y3 ) @ ( id_on @ A @ A3 ) )
      = ( ( X2 = Y3 )
        & ( member @ A @ X2 @ A3 ) ) ) ).

% Id_on_iff
thf(fact_202_rp__inv__image__rp,axiom,
    ! [A: $tType,B: $tType,P: product_prod @ ( set @ ( product_prod @ A @ A ) ) @ ( set @ ( product_prod @ A @ A ) ),F: B > A] :
      ( ( fun_reduction_pair @ A @ P )
     => ( fun_reduction_pair @ B @ ( fun_rp_inv_image @ A @ B @ P @ F ) ) ) ).

% rp_inv_image_rp
thf(fact_203_preorder__on__empty,axiom,
    ! [A: $tType] : ( order_preorder_on @ A @ ( bot_bot @ ( set @ A ) ) @ ( bot_bot @ ( set @ ( product_prod @ A @ A ) ) ) ) ).

% preorder_on_empty
thf(fact_204_termi__while,axiom,
    ! [B3: state > $o,C3: com,F: nat > state,K: nat] :
      ( ( termi @ ( while @ B3 @ C3 ) @ ( F @ K ) )
     => ( ! [I: nat] : ( exec @ ( F @ I ) @ C3 @ ( F @ ( suc @ I ) ) )
       => ? [I: nat] :
            ~ ( B3 @ ( F @ I ) ) ) ) ).

% termi_while
thf(fact_205_termi__while__lemma,axiom,
    ! [W: com,Fk: state,F: nat > state,K: nat,B3: state > $o,C3: com] :
      ( ( termi @ W @ Fk )
     => ( ( ( Fk
            = ( F @ K ) )
          & ( W
            = ( while @ B3 @ C3 ) )
          & ! [I: nat] : ( exec @ ( F @ I ) @ C3 @ ( F @ ( suc @ I ) ) ) )
       => ? [I: nat] :
            ~ ( B3 @ ( F @ I ) ) ) ) ).

% termi_while_lemma
thf(fact_206_wf__iff__no__infinite__down__chain,axiom,
    ! [A: $tType] :
      ( ( wf @ A )
      = ( ^ [R3: set @ ( product_prod @ A @ A )] :
            ~ ? [F4: nat > A] :
              ! [I2: nat] : ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ ( F4 @ ( suc @ I2 ) ) @ ( F4 @ I2 ) ) @ R3 ) ) ) ).

% wf_iff_no_infinite_down_chain
thf(fact_207_wf__no__infinite__down__chainE,axiom,
    ! [A: $tType,R: set @ ( product_prod @ A @ A ),F: nat > A] :
      ( ( wf @ A @ R )
     => ~ ! [K2: nat] : ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ ( F @ ( suc @ K2 ) ) @ ( F @ K2 ) ) @ R ) ) ).

% wf_no_infinite_down_chainE
thf(fact_208_execn_Ointros_I7_J,axiom,
    ! [S2: state,N: nat,T3: state] :
      ( ( execn @ S2 @ body @ N @ T3 )
     => ( execn @ S2 @ call @ ( suc @ N ) @ T3 ) ) ).

% execn.intros(7)
thf(fact_209_pred__nat__def,axiom,
    ( pred_nat
    = ( collect @ ( product_prod @ nat @ nat )
      @ ( product_case_prod @ nat @ nat @ $o
        @ ^ [M: nat,N2: nat] :
            ( N2
            = ( suc @ M ) ) ) ) ) ).

% pred_nat_def
thf(fact_210_while__rule,axiom,
    ! [S2: state,B3: state > $o,C3: com,N: nat,T3: state,P: state > $o] :
      ( ( execn @ S2 @ ( while @ B3 @ C3 ) @ N @ T3 )
     => ( ( P @ S2 )
       => ( ! [S: state,S3: state] :
              ( ( P @ S )
             => ( ( B3 @ S )
               => ( ( execn @ S @ C3 @ N @ S3 )
                 => ( P @ S3 ) ) ) )
         => ( ( P @ T3 )
            & ~ ( B3 @ T3 ) ) ) ) ) ).

% while_rule
thf(fact_211_while__lemma,axiom,
    ! [S2: state,W: com,N: nat,T3: state,B3: state > $o,C3: com,P: state > $o] :
      ( ( execn @ S2 @ W @ N @ T3 )
     => ( ( ( W
            = ( while @ B3 @ C3 ) )
          & ( P @ S2 )
          & ! [S: state,S3: state] :
              ( ( ( P @ S )
                & ( B3 @ S )
                & ( execn @ S @ C3 @ N @ S3 ) )
             => ( P @ S3 ) ) )
       => ( ( P @ T3 )
          & ~ ( B3 @ T3 ) ) ) ) ).

% while_lemma
thf(fact_212_execn_OWhileTrue,axiom,
    ! [B3: state > $o,S2: state,C3: com,N: nat,T3: state,U2: state] :
      ( ( B3 @ S2 )
     => ( ( execn @ S2 @ C3 @ N @ T3 )
       => ( ( execn @ T3 @ ( while @ B3 @ C3 ) @ N @ U2 )
         => ( execn @ S2 @ ( while @ B3 @ C3 ) @ N @ U2 ) ) ) ) ).

% execn.WhileTrue
thf(fact_213_execn_OWhileFalse,axiom,
    ! [B3: state > $o,S2: state,C3: com,N: nat] :
      ( ~ ( B3 @ S2 )
     => ( execn @ S2 @ ( while @ B3 @ C3 ) @ N @ S2 ) ) ).

% execn.WhileFalse
thf(fact_214_exec__iff__execn,axiom,
    ( exec
    = ( ^ [S4: state,C6: com,T4: state] :
        ? [N2: nat] : ( execn @ S4 @ C6 @ N2 @ T4 ) ) ) ).

% exec_iff_execn
thf(fact_215_wf__pred__nat,axiom,
    wf @ nat @ pred_nat ).

% wf_pred_nat
thf(fact_216_nvalid__def,axiom,
    ! [A: $tType] :
      ( ( nvalid @ A )
      = ( ^ [N2: nat,P4: A > state > $o,C6: com,Q4: A > state > $o] :
          ! [S4: state,T4: state] :
            ( ( execn @ S4 @ C6 @ N2 @ T4 )
           => ! [Z4: A] :
                ( ( P4 @ Z4 @ S4 )
               => ( Q4 @ Z4 @ T4 ) ) ) ) ) ).

% nvalid_def
thf(fact_217_termi_OSemi,axiom,
    ! [C1: com,S0: state,C22: com] :
      ( ( termi @ C1 @ S0 )
     => ( ! [S1: state] :
            ( ( exec @ S0 @ C1 @ S1 )
           => ( termi @ C22 @ S1 ) )
       => ( termi @ ( semi @ C1 @ C22 ) @ S0 ) ) ) ).

% termi.Semi
thf(fact_218_com_Oinject_I2_J,axiom,
    ! [X21: com,X222: com,Y21: com,Y222: com] :
      ( ( ( semi @ X21 @ X222 )
        = ( semi @ Y21 @ Y222 ) )
      = ( ( X21 = Y21 )
        & ( X222 = Y222 ) ) ) ).

% com.inject(2)
thf(fact_219_execn_Ointros_I2_J,axiom,
    ! [S0: state,C1: com,N: nat,S12: state,C22: com,S22: state] :
      ( ( execn @ S0 @ C1 @ N @ S12 )
     => ( ( execn @ S12 @ C22 @ N @ S22 )
       => ( execn @ S0 @ ( semi @ C1 @ C22 ) @ N @ S22 ) ) ) ).

% execn.intros(2)
thf(fact_220_com_Odistinct_I13_J,axiom,
    ! [X21: com,X222: com,X41: state > $o,X42: com] :
      ( ( semi @ X21 @ X222 )
     != ( while @ X41 @ X42 ) ) ).

% com.distinct(13)
thf(fact_221_com_Odistinct_I15_J,axiom,
    ! [X21: com,X222: com] :
      ( ( semi @ X21 @ X222 )
     != call ) ).

% com.distinct(15)
thf(fact_222_exec_OSemi,axiom,
    ! [S0: state,C1: com,S12: state,C22: com,S22: state] :
      ( ( exec @ S0 @ C1 @ S12 )
     => ( ( exec @ S12 @ C22 @ S22 )
       => ( exec @ S0 @ ( semi @ C1 @ C22 ) @ S22 ) ) ) ).

% exec.Semi
thf(fact_223_hoare_OSemi,axiom,
    ! [A: $tType,C2: set @ ( product_prod @ ( A > state > $o ) @ ( product_prod @ com @ ( A > state > $o ) ) ),P: A > state > $o,C1: com,Q: A > state > $o,C22: com,R2: A > state > $o] :
      ( ( hoare @ A @ C2 @ P @ C1 @ Q )
     => ( ( hoare @ A @ C2 @ Q @ C22 @ R2 )
       => ( hoare @ A @ C2 @ P @ ( semi @ C1 @ C22 ) @ R2 ) ) ) ).

% hoare.Semi
thf(fact_224_thoare_OSemi,axiom,
    ! [A: $tType,C2: set @ ( product_prod @ ( A > state > $o ) @ ( product_prod @ com @ ( A > state > $o ) ) ),P: A > state > $o,C1: com,Q: A > state > $o,C22: com,R2: A > state > $o] :
      ( ( pHoare166426476thoare @ A @ C2 @ P @ C1 @ Q )
     => ( ( pHoare166426476thoare @ A @ C2 @ Q @ C22 @ R2 )
       => ( pHoare166426476thoare @ A @ C2 @ P @ ( semi @ C1 @ C22 ) @ R2 ) ) ) ).

% thoare.Semi
thf(fact_225_cnvalid__def,axiom,
    ! [A: $tType] :
      ( ( cnvalid @ A )
      = ( ^ [C4: set @ ( product_prod @ ( A > state > $o ) @ ( product_prod @ com @ ( A > state > $o ) ) ),N2: nat,P4: A > state > $o,C6: com,Q4: A > state > $o] :
            ( ( nvalids @ A @ N2 @ C4 )
           => ( nvalid @ A @ N2 @ P4 @ C6 @ Q4 ) ) ) ) ).

% cnvalid_def
thf(fact_226_wf__less__than,axiom,
    wf @ nat @ less_than ).

% wf_less_than
thf(fact_227_total__on__less__than,axiom,
    ! [A3: set @ nat] : ( total_on @ nat @ A3 @ less_than ) ).

% total_on_less_than
thf(fact_228_measure__def,axiom,
    ! [A: $tType] :
      ( ( measure @ A )
      = ( inv_image @ nat @ A @ less_than ) ) ).

% measure_def
thf(fact_229_nvalids__def,axiom,
    ! [A: $tType] :
      ( ( nvalids @ A )
      = ( ^ [N2: nat,C4: set @ ( product_prod @ ( A > state > $o ) @ ( product_prod @ com @ ( A > state > $o ) ) )] :
          ! [X: product_prod @ ( A > state > $o ) @ ( product_prod @ com @ ( A > state > $o ) )] :
            ( ( member @ ( product_prod @ ( A > state > $o ) @ ( product_prod @ com @ ( A > state > $o ) ) ) @ X @ C4 )
           => ( product_case_prod @ ( A > state > $o ) @ ( product_prod @ com @ ( A > state > $o ) ) @ $o
              @ ^ [P4: A > state > $o] : ( product_case_prod @ com @ ( A > state > $o ) @ $o @ ( nvalid @ A @ N2 @ P4 ) )
              @ X ) ) ) ) ).

% nvalids_def
thf(fact_230_mlex__prod__def,axiom,
    ! [A: $tType] :
      ( ( mlex_prod @ A )
      = ( ^ [F4: A > nat,R5: set @ ( product_prod @ A @ A )] :
            ( inv_image @ ( product_prod @ nat @ A ) @ A @ ( lex_prod @ nat @ A @ less_than @ R5 )
            @ ^ [X: A] : ( product_Pair @ nat @ A @ ( F4 @ X ) @ X ) ) ) ) ).

% mlex_prod_def
thf(fact_231_ball__empty,axiom,
    ! [A: $tType,P: A > $o,X5: A] :
      ( ( member @ A @ X5 @ ( bot_bot @ ( set @ A ) ) )
     => ( P @ X5 ) ) ).

% ball_empty
thf(fact_232_Ball__def,axiom,
    ! [A: $tType] :
      ( ( ball @ A )
      = ( ^ [A7: set @ A,P4: A > $o] :
          ! [X: A] :
            ( ( member @ A @ X @ A7 )
           => ( P4 @ X ) ) ) ) ).

% Ball_def
thf(fact_233_wf__mlex,axiom,
    ! [A: $tType,R2: set @ ( product_prod @ A @ A ),F: A > nat] :
      ( ( wf @ A @ R2 )
     => ( wf @ A @ ( mlex_prod @ A @ F @ R2 ) ) ) ).

% wf_mlex
thf(fact_234_refl__on__def_H,axiom,
    ! [A: $tType] :
      ( ( refl_on @ A )
      = ( ^ [A7: set @ A,R3: set @ ( product_prod @ A @ A )] :
            ( ! [X: product_prod @ A @ A] :
                ( ( member @ ( product_prod @ A @ A ) @ X @ R3 )
               => ( product_case_prod @ A @ A @ $o
                  @ ^ [Y5: A,Z4: A] :
                      ( ( member @ A @ Y5 @ A7 )
                      & ( member @ A @ Z4 @ A7 ) )
                  @ X ) )
            & ! [X: A] :
                ( ( member @ A @ X @ A7 )
               => ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ X @ X ) @ R3 ) ) ) ) ) ).

% refl_on_def'
thf(fact_235_ctvalid__def,axiom,
    ! [A: $tType] :
      ( ( pHoare304044376tvalid @ A )
      = ( ^ [C4: set @ ( product_prod @ ( A > state > $o ) @ ( product_prod @ com @ ( A > state > $o ) ) ),P4: A > state > $o,C6: com,Q4: A > state > $o] :
            ( ! [X: product_prod @ ( A > state > $o ) @ ( product_prod @ com @ ( A > state > $o ) )] :
                ( ( member @ ( product_prod @ ( A > state > $o ) @ ( product_prod @ com @ ( A > state > $o ) ) ) @ X @ C4 )
               => ( product_case_prod @ ( A > state > $o ) @ ( product_prod @ com @ ( A > state > $o ) ) @ $o
                  @ ^ [P6: A > state > $o] : ( product_case_prod @ com @ ( A > state > $o ) @ $o @ ( pHoare987424603tvalid @ A @ P6 ) )
                  @ X ) )
           => ( pHoare987424603tvalid @ A @ P4 @ C6 @ Q4 ) ) ) ) ).

% ctvalid_def
thf(fact_236_valids__def,axiom,
    ! [A: $tType] :
      ( ( valids @ A )
      = ( ^ [C4: set @ ( product_prod @ ( A > state > $o ) @ ( product_prod @ com @ ( A > state > $o ) ) )] :
          ! [X: product_prod @ ( A > state > $o ) @ ( product_prod @ com @ ( A > state > $o ) )] :
            ( ( member @ ( product_prod @ ( A > state > $o ) @ ( product_prod @ com @ ( A > state > $o ) ) ) @ X @ C4 )
           => ( product_case_prod @ ( A > state > $o ) @ ( product_prod @ com @ ( A > state > $o ) ) @ $o
              @ ^ [P4: A > state > $o] : ( product_case_prod @ com @ ( A > state > $o ) @ $o @ ( valid @ A @ P4 ) )
              @ X ) ) ) ) ).

% valids_def
thf(fact_237_tvalid__def,axiom,
    ! [A: $tType] :
      ( ( pHoare987424603tvalid @ A )
      = ( ^ [P4: A > state > $o,C6: com,Q4: A > state > $o] :
            ( ( valid @ A @ P4 @ C6 @ Q4 )
            & ! [Z4: A,S4: state] :
                ( ( P4 @ Z4 @ S4 )
               => ( termi @ C6 @ S4 ) ) ) ) ) ).

% tvalid_def
thf(fact_238_cvalid__def,axiom,
    ! [A: $tType] :
      ( ( cvalid @ A )
      = ( ^ [C4: set @ ( product_prod @ ( A > state > $o ) @ ( product_prod @ com @ ( A > state > $o ) ) ),P4: A > state > $o,C6: com,Q4: A > state > $o] :
            ( ( valids @ A @ C4 )
           => ( valid @ A @ P4 @ C6 @ Q4 ) ) ) ) ).

% cvalid_def
thf(fact_239_valid__def,axiom,
    ! [A: $tType] :
      ( ( valid @ A )
      = ( ^ [P4: A > state > $o,C6: com,Q4: A > state > $o] :
          ! [S4: state,T4: state] :
            ( ( exec @ S4 @ C6 @ T4 )
           => ! [Z4: A] :
                ( ( P4 @ Z4 @ S4 )
               => ( Q4 @ Z4 @ T4 ) ) ) ) ) ).

% valid_def
thf(fact_240_Chains__def,axiom,
    ! [A: $tType] :
      ( ( chains @ A )
      = ( ^ [R3: set @ ( product_prod @ A @ A )] :
            ( collect @ ( set @ A )
            @ ^ [C4: set @ A] :
              ! [X: A] :
                ( ( member @ A @ X @ C4 )
               => ! [Y5: A] :
                    ( ( member @ A @ Y5 @ C4 )
                   => ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ X @ Y5 ) @ R3 )
                      | ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ Y5 @ X ) @ R3 ) ) ) ) ) ) ) ).

% Chains_def
thf(fact_241_irrefl__distinct,axiom,
    ! [A: $tType] :
      ( ( irrefl @ A )
      = ( ^ [R3: set @ ( product_prod @ A @ A )] :
          ! [X: product_prod @ A @ A] :
            ( ( member @ ( product_prod @ A @ A ) @ X @ R3 )
           => ( product_case_prod @ A @ A @ $o
              @ ^ [A4: A,B8: A] : ( A4 != B8 )
              @ X ) ) ) ) ).

% irrefl_distinct
thf(fact_242_irrefl__less__than,axiom,
    irrefl @ nat @ less_than ).

% irrefl_less_than
thf(fact_243_wf__imp__irrefl,axiom,
    ! [A: $tType,R: set @ ( product_prod @ A @ A )] :
      ( ( wf @ A @ R )
     => ( irrefl @ A @ R ) ) ).

% wf_imp_irrefl
thf(fact_244_irrefl__def,axiom,
    ! [A: $tType] :
      ( ( irrefl @ A )
      = ( ^ [R3: set @ ( product_prod @ A @ A )] :
          ! [A4: A] :
            ~ ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A4 @ A4 ) @ R3 ) ) ) ).

% irrefl_def
thf(fact_245_irreflI,axiom,
    ! [A: $tType,R2: set @ ( product_prod @ A @ A )] :
      ( ! [A6: A] :
          ~ ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A6 @ A6 ) @ R2 )
     => ( irrefl @ A @ R2 ) ) ).

% irreflI
thf(fact_246_irreflp__irrefl__eq,axiom,
    ! [A: $tType,R2: set @ ( product_prod @ A @ A )] :
      ( ( irreflp @ A
        @ ^ [A4: A,B8: A] : ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A4 @ B8 ) @ R2 ) )
      = ( irrefl @ A @ R2 ) ) ).

% irreflp_irrefl_eq
thf(fact_247_Powp__def,axiom,
    ! [A: $tType] :
      ( ( powp @ A )
      = ( ^ [A7: A > $o,B5: set @ A] :
          ! [X: A] :
            ( ( member @ A @ X @ B5 )
           => ( A7 @ X ) ) ) ) ).

% Powp_def
thf(fact_248_irreflp__def,axiom,
    ! [A: $tType] :
      ( ( irreflp @ A )
      = ( ^ [R5: A > A > $o] :
          ! [A4: A] :
            ~ ( R5 @ A4 @ A4 ) ) ) ).

% irreflp_def
thf(fact_249_irreflpI,axiom,
    ! [A: $tType,R2: A > A > $o] :
      ( ! [A6: A] :
          ~ ( R2 @ A6 @ A6 )
     => ( irreflp @ A @ R2 ) ) ).

% irreflpI
thf(fact_250_trans__join,axiom,
    ! [A: $tType] :
      ( ( trans @ A )
      = ( ^ [R3: set @ ( product_prod @ A @ A )] :
          ! [X: product_prod @ A @ A] :
            ( ( member @ ( product_prod @ A @ A ) @ X @ R3 )
           => ( product_case_prod @ A @ A @ $o
              @ ^ [Y5: A,Y12: A] :
                ! [Z4: product_prod @ A @ A] :
                  ( ( member @ ( product_prod @ A @ A ) @ Z4 @ R3 )
                 => ( product_case_prod @ A @ A @ $o
                    @ ^ [Y23: A,Aa: A] :
                        ( ( Y12 = Y23 )
                       => ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ Y5 @ Aa ) @ R3 ) )
                    @ Z4 ) )
              @ X ) ) ) ) ).

% trans_join
thf(fact_251_in__measure,axiom,
    ! [A: $tType,X2: A,Y3: A,F: A > nat] :
      ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ X2 @ Y3 ) @ ( measure @ A @ F ) )
      = ( ord_less @ nat @ ( F @ X2 ) @ ( F @ Y3 ) ) ) ).

% in_measure
thf(fact_252_trans__less__than,axiom,
    trans @ nat @ less_than ).

% trans_less_than
thf(fact_253_less__than__iff,axiom,
    ! [X2: nat,Y3: nat] :
      ( ( member @ ( product_prod @ nat @ nat ) @ ( product_Pair @ nat @ nat @ X2 @ Y3 ) @ less_than )
      = ( ord_less @ nat @ X2 @ Y3 ) ) ).

% less_than_iff
thf(fact_254_trans__lex__prod,axiom,
    ! [A: $tType,B: $tType,R1: set @ ( product_prod @ A @ A ),R22: set @ ( product_prod @ B @ B )] :
      ( ( trans @ A @ R1 )
     => ( ( trans @ B @ R22 )
       => ( trans @ ( product_prod @ A @ B ) @ ( lex_prod @ A @ B @ R1 @ R22 ) ) ) ) ).

% trans_lex_prod
thf(fact_255_trans__Id__on,axiom,
    ! [A: $tType,A3: set @ A] : ( trans @ A @ ( id_on @ A @ A3 ) ) ).

% trans_Id_on

% Type constructors (5)
thf(tcon_fun___Orderings_Obot,axiom,
    ! [A9: $tType,A10: $tType] :
      ( ( bot @ A10 )
     => ( bot @ ( A9 > A10 ) ) ) ).

thf(tcon_Nat_Onat___Orderings_Obot_1,axiom,
    bot @ nat ).

thf(tcon_Set_Oset___Orderings_Obot_2,axiom,
    ! [A9: $tType] : ( bot @ ( set @ A9 ) ) ).

thf(tcon_HOL_Obool___Orderings_Obot_3,axiom,
    bot @ $o ).

thf(tcon_Product__Type_Ounit___Orderings_Obot_4,axiom,
    bot @ product_unit ).

% Helper facts (3)
thf(help_If_3_1_T,axiom,
    ! [P: $o] :
      ( ( P = $true )
      | ( P = $false ) ) ).

thf(help_If_2_1_T,axiom,
    ! [A: $tType,X2: A,Y3: A] :
      ( ( if @ A @ $false @ X2 @ Y3 )
      = Y3 ) ).

thf(help_If_1_1_T,axiom,
    ! [A: $tType,X2: A,Y3: A] :
      ( ( if @ A @ $true @ X2 @ Y3 )
      = X2 ) ).

% Conjectures (3)
thf(conj_0,hypothesis,
    ! [S7: state] :
      ( ( pHoare166426476thoare @ a
        @ ( insert @ ( product_prod @ ( a > state > $o ) @ ( product_prod @ com @ ( a > state > $o ) ) )
          @ ( product_Pair @ ( a > state > $o ) @ ( product_prod @ com @ ( a > state > $o ) )
            @ ^ [Z4: a,S4: state] :
                ( ( pa @ Z4 @ S4 )
                & ( member @ ( product_prod @ state @ state ) @ ( product_Pair @ state @ state @ S4 @ S7 ) @ r ) )
            @ ( product_Pair @ com @ ( a > state > $o ) @ call @ qa ) )
          @ ( bot_bot @ ( set @ ( product_prod @ ( a > state > $o ) @ ( product_prod @ com @ ( a > state > $o ) ) ) ) ) )
        @ ^ [Z4: a,S4: state] :
            ( ( pa @ Z4 @ S4 )
            & ( S4 = S7 ) )
        @ body
        @ qa )
      & ( ( ! [S: state,T2: state] :
              ( ( exec @ S @ body @ T2 )
             => ! [Z: a] :
                  ( ( ( pa @ Z @ S )
                    & ( member @ ( product_prod @ state @ state ) @ ( product_Pair @ state @ state @ S @ S7 ) @ r ) )
                 => ( qa @ Z @ T2 ) ) )
          & ! [Z: a,S: state] :
              ( ( ( pa @ Z @ S )
                & ( member @ ( product_prod @ state @ state ) @ ( product_Pair @ state @ state @ S @ S7 ) @ r ) )
             => ( termi @ body @ S ) ) )
       => ( ! [S8: state,T5: state] :
              ( ( exec @ S8 @ body @ T5 )
             => ! [Z2: a] :
                  ( ( ( pa @ Z2 @ S8 )
                    & ( S8 = S7 ) )
                 => ( qa @ Z2 @ T5 ) ) )
          & ! [Z2: a,S8: state] :
              ( ( ( pa @ Z2 @ S8 )
                & ( S8 = S7 ) )
             => ( termi @ body @ S8 ) ) ) ) ) ).

thf(conj_1,hypothesis,
    ! [Y4: state] :
      ( ( member @ ( product_prod @ state @ state ) @ ( product_Pair @ state @ state @ Y4 @ x ) @ r )
     => ( ! [S8: state,T5: state] :
            ( ( exec @ S8 @ body @ T5 )
           => ! [Z2: a] :
                ( ( ( pa @ Z2 @ S8 )
                  & ( S8 = Y4 ) )
               => ( qa @ Z2 @ T5 ) ) )
        & ! [Z2: a,S8: state] :
            ( ( ( pa @ Z2 @ S8 )
              & ( S8 = Y4 ) )
           => ( termi @ body @ S8 ) ) ) ) ).

thf(conj_2,conjecture,
    ( ! [S: state,T2: state] :
        ( ~ ( exec @ S @ body @ T2 )
        | ! [Z: a] :
            ( ~ ( pa @ Z @ S )
            | ( S != x )
            | ( qa @ Z @ T2 ) ) )
    & ! [Z: a,S: state] :
        ( ~ ( pa @ Z @ S )
        | ( S != x )
        | ( termi @ body @ S ) ) ) ).

%------------------------------------------------------------------------------
